/***************************************************************************
                          transferpanel.h  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNAP_TRANSFERPANEL_H
#define KNAP_TRANSFERPANEL_H

#include <qframe.h>
#include <qlist.h>

class KNAP_ListView;
class QListViewItem;
class QPoint;
class QLabel;
class QPopupMenu;
class SongInfo;
class KSocket;

//class NapsterTransfer;

typedef QList<SongInfo> TransferList; 
/**the transfer panel
  *@author John Donoghue
  */

#define DLV_FILE     0
#define DLV_READ     1
#define DLV_RATE     2
#define DLV_USER     3
#define DLV_STATUS   4
#define DLV_PROGRESS 5
#define DLV_TIMELEFT 6

#define DLV_XTRA     7 /* used to store the internal ID used to be full filepath name */


class KNAP_TransferPanel 
: public QFrame  
{
   Q_OBJECT
signals:
  // sigs for popupmenu selections occuring
// TODO remove these
  void terminate(QListViewItem *);

  void terminate_and_delete(QListViewItem *);

  void play(const char *);

//  void ping(const char *);
//  void whois(const char *);
//  void addFriend(const char *);

  void sendcommand(const char *);
public slots:
  // clear the listview
  void clear();


private slots:
  void popupMenu( QListViewItem *, const QPoint &, int);

  void popupClear();

  void popupDownloadPlay();
  void popupDownloadTerminate();
	
  void popupDownloadTerminateAndDelete();

  void popupPing();
  void popupWhois();
  void popupAddFriend();

  void timerUpdate();
public: 
  KNAP_TransferPanel(QWidget *parent=0, const char *name=0);
  virtual ~KNAP_TransferPanel();

  //void addDownloadItem(SongInfo *song);
  //// TODO change to addTransferItem() etc
  void addDownloadItem(const char *user,const char *file);
  void removeDownloadItem(SongInfo *song);

  bool startDownload(SongInfo *sg, const char *saveto,const char *us);
  bool startDownload(KSocket *s,SongInfo *sg, const char *saveto,const char *us);
  
  bool startUpload(KSocket *s,SongInfo *sg, const char *saveto,const char *us);
  bool startUpload(SongInfo *sg,const char *us);

  bool stopDownload(SongInfo *sg,bool findbyid=false,bool naperror=false);

  bool showDownloadPath() const;
  void setShowDownloadPath(bool yes);

  static QString convertDownloadStatus(long s);

  int numItems() const;

  QPopupMenu * getPopupMenu() const;
                                                                                           
private:
  QListViewItem *findItem(SongInfo *sg);
  void updateTransferItem(SongInfo *song,bool isdownload);

  TransferList transfers;
  
  QPopupMenu *transferpopupmenu;
  KNAP_ListView *transferlistview;
  
  bool showtransferpath;

};

#endif
