/***************************************************************************
                          support_funcs.cpp  -  description
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "support_funcs.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

long getFileSize(const char *filename)
{
   struct stat statbuff;
   long size=0;

   if(filename && stat(filename,&statbuff)==0) {
        size=statbuff.st_size;
   }
   return size;
}

QString convertSize(long sz)
{
   char buff[30];
   if(sz >=(1024*1024*1024)) {
      sprintf(buff,"%.3f Gb",((double)sz)/(1024*1024*1024));
   }
   if(sz>=(1024*1024)) {
      sprintf(buff,"%.3f Mb",((double)sz)/(1024*1024));
   }
   else if(sz>=1024) {
      sprintf(buff,"%.2f Kb",((double)sz)/(1024));
   }
   else  sprintf(buff,"%ld Byte%s",sz,(sz!=1 ? "s" : "" ));

   return QString(buff);
}

QString convertSpeed(int speed)
{
  static char *strs[]={
   "Unknown",
   "14.4K",
   "28.8K",
   "34.6K",
   "57.6K",
   "64K ISDN",
   "128K ISDN",
   "CABLE",
   "DSL",
   "T1",
   "T3+"
  };

  if(speed<0 || speed>10) speed=0;

  return QString(strs[speed]);
}
QString makeFullFilePath(const QString &path,const QString &file)
{
  QString a;
  int p;

  p=path.findRev("/");
  if(p==-1 || p < path.length()-1) a= path + "/" + file;
  else a=path + file;

  return a;
}

// extract a string from a string - this is the first word
// or a series of words if in "xxxxxxx'
QString extractString(QString &s)
{
  int p;

  QString ret=s.stripWhiteSpace();

  if(ret.isNull()) return ret;

  if(*ret=='"') {  // a string
     p=ret.find('"',1);
     if(p==-1) p=ret.length();
     if(p<ret.length()-1) s=ret.right(ret.length()-(p+1));
     else s="";

     ret=ret.mid(1,p-1);
  }
  else {  // get just a word
     p=ret.find(' ');
     if(p==-1) p=ret.length();

     if(p<ret.length()) s=ret.right(ret.length()-p);
     else s="";

     ret=ret.left(p);
  }
  return ret;
}

// convenience function for extarcting the filename from a path\filename
// ASSUMES DOS paths
QString getFileName(const QString &path)
{
  QString a;
  int p;

  p=path.findRev("\\");
  if(p==-1) a=path;
  else a=path.mid(p+1,path.length()-(p+1));

  return a;
}

// convert a unix path into a dos one
// if there is a leading '/' it is removed
QString toDosName(const QString &name)
{
  QString a=name;
  int p=0;

  while(p!=-1) {
    p=a.find("/",p);
    if(p==0) a=a.replace(0,1,"");
    else if(p!=-1) a=a.replace(p,1,"\\");
  }
  return a;
}

QString toUnixName(const QString &name)
{
  QString a=name;
  int p=0;

  if(name=="") return name;

  // put a leading /
  if(name[0] != '/') a="/" + name;

  while(p!=-1) {
    p=a.find("\\",p);
    if(p!=-1) a=a.replace(p,1,"/");
  }
  return a;
}

#ifdef NEED_INET_ATON
/* convert a XXX.XXX.XXX.XXX string to a network long */
int inet_aton(const char *str,struct in_addr *to)
{
  int n[4];
  int ok;

  if(!str) return 0;

  ok=sscanf(str,"%d.%d.%d.%d",&n[0],&n[1],&n[2],&n[3]);
  to->s_addr=(n[0] << 24) + (n[1]<<16)+(n[2]<<8)+n[3];

  if(ok<4) ok=0;

  return(ok);
}
#endif
