/***************************************************************************
                          searchpanel.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "searchpanel.h"

#include <qpopupmenu.h>
#include <kapp.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcombo.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qpushbutton.h>
#ifdef KDE2
#include <klocale.h>
#endif

#include "songinfo.h"
#include "support_funcs.h"
#include "extcombobox.h"

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

class SearchResultItem : public QListViewItem {
public:
  SearchResultItem(QListView *parent,const char *s1,const char *s2,const char *s3,
		   const char *s4,const char *s5,const char *s6,const char *s7)
    : QListViewItem(parent,s1,s2,s3,s4,s5,s6,s7)
  { }
#ifdef KDE2
  virtual QString text(int col) const
#else
  virtual const char *text(int col) const
#endif /* KDE2 */
  {
    static QString ret; // Copied on return from function so ok, even if ugly.

    if (col==3) {
      ret=convertSpeed(atoi(QListViewItem::text(col)));
      return ret;
    } else
      return QListViewItem::text(col);
  }
#ifdef KDE2
  virtual QString key(int col,bool asc) const
#else
  virtual const char *key(int col,bool asc) const
#endif /* KDE2 */
  {
    return QListViewItem::text(col);
  }
};

SearchPanel::SearchPanel(QWidget *parent, const char *name )
: QWidget(parent,name)
{
  int basewidth;
                                   /* rows,cols , space,space*/
  QGridLayout *grid=new QGridLayout(this,4,6,5,5);

  QLabel *l=new QLabel(i18n("Search for "),this);
  l->setMaximumWidth( l->sizeHint().width() );
  grid->addWidget(l,0,0);

  searchoption=new QComboBox(false,this,"searchoption");
  searchoption->insertItem(i18n("TEXT IN TITLE"));
  searchoption->insertItem(i18n("USER"));
  searchoption->setMaximumSize( searchoption->sizeHint() );
  basewidth=searchoption->sizeHint().width();
  // all othe ctrls are based on this width
  grid->addWidget(searchoption,0,1);
  // we want to know when to ghost the other options
  connect(searchoption,SIGNAL(activated(int)),this,SLOT(searchComboActivated(int)));


//  searchtext=new QLineEdit(this,"searchtext");
  searchtext=new ExtComboBox(true,this,"searchtext");
  searchtext->setMaxCount(8);
//  searchtext->setInsertionPolicy(QComboBox::AtTop);

//  searchtext->setMaxLength(60);
  connect(searchtext,SIGNAL(returnPressed()),this,SLOT(calcSearch()));

  grid->addMultiCellWidget(searchtext,0,0,2,4);

  searchbutton=new QPushButton(i18n("Search"),this,"searchbutton");
  searchbutton->setMaximumWidth( basewidth );
  connect(searchbutton,SIGNAL(clicked()),this,SLOT(calcSearch()));
  grid->addWidget(searchbutton,0,5);

  // the other search options
  l=new QLabel(i18n("Speed "),this);
  grid->addWidget(l,1,0);

  speedoption=createCompareValueCB("speedoption");
  speedoption->setMaximumHeight( speedoption->sizeHint().height() );
  grid->addWidget(speedoption,1,1);
  connect(speedoption,SIGNAL(activated(int)),this,SLOT(optionComboActivated(int)));

  speedtext=new QComboBox(false,this,"speedtext");
  for(int i=0;i<=10;i++) {
    speedtext->insertItem( convertSpeed(i) );
  }
  speedtext->setMaximumWidth( basewidth );
  grid->addWidget(speedtext,1,2);

  l=new QLabel(i18n("Bitrate "),this);
  l->setAlignment(AlignRight);
  grid->addWidget(l,1,3);

  bitrateoption=createCompareValueCB("bitrateoption");
  bitrateoption->setMaximumWidth( basewidth );
  grid->addWidget(bitrateoption,1,4);
  connect(bitrateoption,SIGNAL(activated(int)),this,SLOT(optionComboActivated(int)));

  bitratetext=new QComboBox(false,this,"bitratetext");
  bitratetext->insertItem(i18n("64"));
  bitratetext->insertItem(i18n("74"));
  bitratetext->insertItem(i18n("96"));
  bitratetext->insertItem(i18n("112"));
  bitratetext->insertItem(i18n("128"));
  bitratetext->insertItem(i18n("160"));
  bitratetext->insertItem(i18n("192"));
  bitratetext->insertItem(i18n("256"));

  grid->addWidget(bitratetext,1,5);

  l=new QLabel(i18n("Frequency "),this);
  grid->addWidget(l,2,0);

  freqoption=createCompareValueCB("freqoption");
  freqoption->setMaximumHeight( freqoption->sizeHint().height() );
  grid->addWidget(freqoption,2,1);
  connect(freqoption,SIGNAL(activated(int)),this,SLOT(optionComboActivated(int)));

  freqtext=new QComboBox(false,this,"freqtext");
  freqtext->insertItem(i18n("11025"));
  freqtext->insertItem(i18n("22050"));
  freqtext->insertItem(i18n("44100"));
  freqtext->insertItem(i18n("48800")); //?????????

  grid->addWidget(freqtext,2,2);

  l=new QLabel(i18n("Max results "),this);
  l->setAlignment(AlignRight);
  grid->addWidget(l,2,3);

  resultstext=new QLineEdit(this,"resultstext");
  // only allows 100 in napster anyway - more are ignored
  resultstext->setMaxLength(3);
  resultstext->setText(i18n("100"));
  grid->addWidget(resultstext,2,4);

  searchlistview=new QListView(this);
  searchlistview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  searchlistview->addColumn(i18n("file"),280);
  searchlistview->setColumnWidthMode(0,QListView::Manual);
  searchlistview->addColumn(i18n("size"),80);
  searchlistview->setColumnWidthMode(1,QListView::Manual);
  searchlistview->addColumn(i18n("frequency"),60);
  searchlistview->setColumnWidthMode(2,QListView::Manual);
  searchlistview->addColumn(i18n("speed"),80);
  searchlistview->setColumnWidthMode(3,QListView::Manual);
  searchlistview->addColumn(i18n("bitrate"));
  searchlistview->setColumnWidthMode(4,QListView::Manual);
  searchlistview->addColumn(i18n("user"),100);
  searchlistview->setColumnWidthMode(5,QListView::Manual);

  searchlistview->setSorting(3); // sort on insertion   ** was -1

  multiselect =  true;
  searchlistview->setMultiSelection(true); // allow multi selects

  grid->addMultiCellWidget(searchlistview,3,3,0,5);

  // setup the poup

  searchpopupmenu=new QPopupMenu();
  if(searchpopupmenu) {
    searchpopupmenu->insertItem(i18n("Download file"),this,SLOT(popupSearchDownload()));
    searchpopupmenu->insertSeparator();
    searchpopupmenu->insertItem(i18n("Ping User"),this,SLOT(popupPing()));
    searchpopupmenu->insertItem(i18n("Whois this User"),this,SLOT(popupWhois()));

    searchpopupmenu->insertSeparator();
    searchpopupmenu->insertItem(i18n("Clear search list"),this,SLOT(clearSearch()));

    searchpopupmenu->insertSeparator();
    searchpopupmenu->insertItem("Toggle Show Path",this,SLOT(popupShowPath()));
  }
  connect(searchlistview,SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
       this,SLOT(popupSearch( QListViewItem *, const QPoint &, int )));


  // set up the search items as enabled
  setExtraOptionsEnabled(true);

  // don't show paths as the default
  showsearchpath = false;
}
SearchPanel::~SearchPanel()
{
}
void SearchPanel::calcSearch()
{
  int type=searchoption->currentItem();
  const char *txt=searchtext->currentText();

  if(!txt || *txt=='\0') return;

   // make sure the text was saved in the combo list
   searchtext->saveText();


  if(type==0) {
    const char *m=resultstext->text();

    if(QString(m).toInt()<=0) m="100";

    QString tmp="FILENAME CONTAINS \"";

    tmp+=txt;
    tmp+="\" MAX_RESULTS ";
    tmp+=m;

    if(speedtext->isEnabled()) {
       tmp+=" LINESPEED \"";
       tmp+=speedoption->currentText();
       tmp+="\" ";
       tmp+= QString().setNum(speedtext->currentItem());
    }
    if(bitratetext->isEnabled()) {
       tmp+=" BITRATE \"";
       tmp+=bitrateoption->currentText();
       tmp+="\" \"";
       tmp+=bitratetext->currentText();
       tmp+="\"";

    }
    if(freqtext->isEnabled()) {
       tmp+=" FREQ \"";
       tmp+=freqoption->currentText();
       tmp+="\" \"";
       tmp+=freqtext->currentText();
       tmp+="\"";
    }
#ifdef DEBUG_1
    cerr<<"Sending query if: "<<tmp<<endl<<flush;
#endif
    emit search(type,tmp);

  }
  else emit search(type,txt);

  return;
}

void SearchPanel::addSearchItem(SongInfo *song /*,bool showsearchpath*/)
{
  if(!song) return;

  QString s_filename;
  if(!showsearchpath) s_filename=getFileName(song->filename);
  else s_filename=song->filename;

  QListViewItem *i;

  // put the item in the listview
  // field 6 is invisible & holds the FULL path name of the song

  char buf[10];
  sprintf(buf,"%05d",song->speed);

  i=new SearchResultItem(searchlistview,
			 s_filename,
			 convertSize(song->size),
			 QString().setNum(song->freq),
			 buf,
			 QString().setNum(song->bitrate),
			 song->user,song->filename);

}

void SearchPanel::popupSearch( QListViewItem *i, const QPoint &pos, int col)
{
  QListViewItem *selecteditem=searchlistview->currentItem();
  if(searchpopupmenu && selecteditem) {
     searchpopupmenu->exec(QCursor::pos());
  }
}

void SearchPanel::clearSearch()
{
  searchlistview->clear();
}

void SearchPanel::popupSearchDownload()
{
  QListViewItem *item=searchlistview->firstChild();
  //searchlistview->currentItem();

  while(item) {
     if(item->isSelected()) {
        // selected so download it
        emit download(item);
        searchlistview->setSelected(item,false);
     }
     item = item->nextSibling();
  }
}

void SearchPanel::popupPing()
{
/*  QListViewItem *selecteditem=searchlistview->currentItem();

  if(selecteditem) {
     emit ping(selecteditem->text(5));
  }
*/
  QListViewItem *item=searchlistview->firstChild();
  //searchlistview->currentItem();

  while(item) {
     if(item->isSelected()) {
        // selected so download it
        emit ping(item->text(5));
        //searchlistview->setSelected(item,false);
     }
     item = item->nextSibling();
  }

}

void SearchPanel::popupWhois()
{
/*  QListViewItem *selecteditem=searchlistview->currentItem();

  if(selecteditem) {
     emit whois(selecteditem->text(5));
  }
*/
  QListViewItem *item=searchlistview->firstChild();
  //searchlistview->currentItem();

  while(item) {
     if(item->isSelected()) {
        // selected so download it
        emit whois(item->text(5));
        //searchlistview->setSelected(item,false);
     }
     item = item->nextSibling();
  }

}


bool SearchPanel::showSearchPath() const
{
  return showsearchpath;
}
void SearchPanel::setShowSearchPath(bool yes)
{
  QString s_filename;

  if(showsearchpath!=yes)
  {
    QListViewItem *it=searchlistview->firstChild();
    while(it) {
        if(!yes) s_filename=getFileName(it->text(6));
        else s_filename=it->text(6);

        it->setText(0,s_filename);

        it=it->nextSibling();
    }

    showsearchpath=yes;
  }
  return;
}
void SearchPanel::setMultiSelect(bool yes)
{
  QString s_filename;

  if(multiselect!=yes)
  {
    // unselect all if not multi select????
    QListViewItem *item=searchlistview->firstChild();

    while(item) {
      if(item->isSelected())
        searchlistview->setSelected(item,false);
      item = item->nextSibling();
    }

    searchlistview->setMultiSelection(yes); // allow multi selects

    multiselect=yes;
  }
  return;
}

// slot for when the searchoption combo is cativated
// ( an item is selected/changed )
void SearchPanel::searchComboActivated(int v)
{
  if(v==1) { // search by user -> ghost all other options
     setExtraOptionsEnabled(false);
  }
  else { // otherwise unghost all options
     setExtraOptionsEnabled(true);
  }
  return;
}

// slot for when one of the other search option combos is cativated
// ( an item is selected/changed )
void SearchPanel::optionComboActivated(int v)
{
  // don't really care about the value here
  // setExtraOptionsEnabled will handle
  setExtraOptionsEnabled(true); // we only get this msg if an option was enabled
}

// enable/disable the extra search options in the search panel
// NOTE: that even if enable is true, some widgets will only
// be enabled if their sibling widget allows them to be
// ie if speed option is Don't care, then the speed combo will always
// be disabled
void SearchPanel::setExtraOptionsEnabled(bool enable)
{

  speedoption->setEnabled(enable);
  bitrateoption->setEnabled(enable);
  freqoption->setEnabled(enable);

  resultstext->setEnabled(enable);

  speedtext->setEnabled( enable && speedoption->currentItem()!=0 );
  bitratetext->setEnabled( enable && bitrateoption->currentItem()!=0 );
  freqtext->setEnabled( enable && freqoption->currentItem()!=0 );

  return;
}


QComboBox * SearchPanel::createCompareValueCB(const char *name)
{
  QComboBox *cb;
  // creates a combo box with the items
  // DONT CARE
  // AT LEAST
  // AT BEST
  // EQUAL TO
  cb=new QComboBox(false,this,name);
  cb->insertItem(i18n("DONT CARE"));
  cb->insertItem(i18n("AT LEAST"));
  cb->insertItem(i18n("AT BEST"));
  cb->insertItem(i18n("EQUAL TO"));

  return cb;
}

void SearchPanel::popupShowPath()
{
  /*  QListViewItem *selecteditem=searchlistview->currentItem();
   if(selecteditem) {
    emit whois(selecteditem->text(5));
  }
  */
   setShowSearchPath(!showsearchpath);
}
