/***************************************************************************
                          napstertransfer.h  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NAPSTERTRANSFER_H
#define NAPSTERTRANSFER_H


/**The base class for napster file transfers.
It is used by NapsterDownload and NapsterUpload
classes
  *@author John Donoghue
  */

#include <qstring.h>

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#include <pthread.h>
#include <sys/time.h>


class NapsterTransfer {

protected:
  struct sockaddr_in _sockaddr;

  long _totalsize;
  long _readsize;
  long _status;

  QString _filename;
  int _speed;
  QString _user;
  QString _dest;
  QString _destname;

  pthread_mutex_t _mutex;

  time_t _starttime;

  bool _terminate;
  bool _connected;

public:
  enum { DL_NOLOCALFILE=-4,DL_NOCONNECT=-3,DL_KILLED=-2,DL_ERROR=-1,
         DL_QUEUED=0,DL_INIT=1,
         DL_DOWNLOADING=2,DL_FINISHED=3 };

  bool isConnected() { return _connected; }

  // must provide a start function for the download type
  virtual bool start(int listen=-1,long sz=0)=0;

	virtual ~NapsterTransfer();

  bool cancel();

  void setInit() { _status=DL_INIT; }   // required for dload2 :(

  bool getInfo(long *status,long *read,long *total,long *bps);

  QString getLocalName() { return _destname; }
protected:
  // only can be created by inherited classes
  // such as Upload/Download
	NapsterTransfer(long ip,int port,const char *filename,const char *user,
        int speed,const char *dest);

  void down();
  void up();
  bool trydown();

  void setSigpipeHandler();
};

#endif