/***************************************************************************
                          napstertransfer.cpp  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napstertransfer.h"

NapsterTransfer::NapsterTransfer(long ip,int port,const char *filename,
        const char *user,int speed,const char *dest)
{
   _connected=false;

   _readsize=0;
   _totalsize=0;
   _status=DL_QUEUED;

   _terminate=false;

   _user=user;
   _speed=speed;
   _filename=filename;

   _destname=dest;

   _starttime=0;

   pthread_mutex_init(&_mutex,NULL);

   memset(&_sockaddr,0,sizeof(_sockaddr));
   _sockaddr.sin_family = AF_INET;
   _sockaddr.sin_port = htons(port);
   _sockaddr.sin_addr.s_addr = ip;

}
NapsterTransfer::~NapsterTransfer()
{
  pthread_mutex_destroy(&_mutex);
}
bool NapsterTransfer::cancel()
{
  down();
    _terminate=true;
    if(_status==DL_QUEUED) _status=DL_KILLED;
  up();

  return true;
}

bool NapsterTransfer::getInfo(long *status,long *red,long *total,long *bps)
{
  down();

  if(status) *status=_status;
  if(red) *red=_readsize;
  if(total) *total=_totalsize;

  if(bps) {
    *bps=0;

    time_t currtime;
    time(&currtime); // set the start time
    if(_starttime!=0) {
      currtime=currtime-_starttime; // number of elased seconds

      if(currtime<1) currtime=1;

       *bps=_readsize/currtime;
     }
  }

  up();

  return true;
}

void NapsterTransfer::down()
{
 pthread_mutex_lock(&_mutex);
}

void NapsterTransfer::up()
{
  pthread_mutex_unlock(&_mutex);
}

// currently not used
bool NapsterTransfer::trydown()
{
 if(pthread_mutex_trylock(&_mutex)==0) return true;
 return false;
}