/***************************************************************************
                          napsterdownload.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au

  NOTE *********************************************************************

  parts of the download code are loosely based on 'gnap' by

  Ryan Dahl,
  http://gnap.sourceforge.net

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NAPSTERDOWNLOAD_H
#define NAPSTERDOWNLOAD_H


/**
  *@author John Donoghue
  */
#include "songinfo.h"

#include "napstertransfer.h"

class NapsterConnection;

class NapsterDownload : public NapsterTransfer {
  friend NapsterConnection;


  char _buffer[2048];

  int _sock;
  int _file;

  int _listener;

  int _header_pos;
  bool _gotheader;

  pthread_t _id;

private:
	NapsterDownload(long ip,int port,const char *filename,const char *user,
        int speed,const char *dest);
  bool header();
  bool header_new();
  bool data();
  bool init();

  bool processDownload();

  bool setDownloadName(const char *path,bool trucate=false);

  int getSocket() { return _sock; }

  static void *thread_task(NapsterDownload *dl);

public:
	virtual ~NapsterDownload();

  bool start(int listen=-1,long sz=0);
};


#endif