/***************************************************************************
                          downloadpanel.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "downloadpanel.h"
#include <qlistview.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <kapp.h>
#include <qlabel.h>


#include "support_funcs.h"

//#include "searchpanel.h"
#include "songinfo.h"
#include "napsterdownload.h"

#include <stdlib.h>

class DownloadListItem : public QListViewItem {
//private:
//  long bytesread,bytesize;
public:
  DownloadListItem(QListView *parent,const char *s1,const char *s2,const char *s3,
		   const char *s4,const char *s5,const char *s6,const char *s7,const char *s8)
    : QListViewItem(parent,s1,s2,s3,s4,s5,s6,s7,s8)
  { }
#ifdef KDE2
  virtual QString text(int col) const
#else
  virtual const char *text(int col) const
#endif /* KDE2 */
  {
    static QString ret; // Copied on return from function so ok, even if ugly.

    if (col==DLV_READ || col==DLV_SIZE) {
      ret=convertSize(atoi(QListViewItem::text(col)));
      return ret;
    }
//    else if (col==DLV_SIZE ) {
//      ret=convertSize(atoi(QListViewItem::text(DLV_SIZE)));
//      return ret;
//    }
    else
      return QListViewItem::text(col);
  }
  virtual void paintCell (QPainter * p,const QColorGroup &cg,int column,
     int width,int align)
  {
     if(column!=DLV_PROGRESS) QListViewItem::paintCell(p,cg,column,width,align);
     else {
       // paint the pseudo progressbar
       p->setPen(cg.dark());
       p->drawRect(0,0,width,height());
       p->fillRect(1,1,width-2,height()-2,cg.base());
       double v; // = width-1;
       int rd = atoi(QListViewItem::text(DLV_READ));
       int sz = atoi(QListViewItem::text(DLV_SIZE));
       if(sz>0) {
          v = ((double)rd / sz * (double)(width -2));

          if(v>1.0) p->fillRect(1,1,(int)v,height()-2,cg.midlight());
          v = ((double)rd / sz * 100.0);
          // show the text
          p->setPen(cg.text());
          p->drawText(0,0,width-1,height()-1,AlignCenter,QString().setNum((int)v) + "%");

       }
     }
  }
};


DownloadPanel::DownloadPanel(QWidget *parent, const char *name )
: QWidget(parent,name)
{
  showdownloadpath=false;

  //QWidget *frame=new QWidget(parent);
  QGridLayout *grid=new QGridLayout(this,1,1,5,5);

//  stats=new QLabel("0 Songs",this,"stats");
//  stats->setMaximumHeight( stats->sizeHint().height() );
//  grid->addWidget(stats,0,0);

  downloadlistview=new QListView(this);
  downloadlistview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  grid->addMultiCellWidget(downloadlistview,0,0,0,0);

  downloadlistview->addColumn("file",200);
  downloadlistview->setColumnWidthMode(DLV_FILE,QListView::Manual);
  downloadlistview->addColumn("read",80);
  downloadlistview->setColumnWidthMode(DLV_READ,QListView::Manual);
  downloadlistview->addColumn("size",80);
  downloadlistview->setColumnWidthMode(DLV_SIZE,QListView::Manual);
  downloadlistview->addColumn("rate/s",80);
  downloadlistview->setColumnWidthMode(DLV_RATE,QListView::Manual);
  downloadlistview->addColumn("user",80);
  downloadlistview->setColumnWidthMode(DLV_USER,QListView::Manual);
  downloadlistview->addColumn("status",80);
  downloadlistview->setColumnWidthMode(DLV_STATUS,QListView::Manual);

  downloadlistview->addColumn("progress",80);
  downloadlistview->setColumnWidthMode(DLV_PROGRESS,QListView::Manual);

  // create the popup menu for the downloadlist view
  downloadpopupmenu=new QPopupMenu();
  if(downloadpopupmenu) {
//  downloadpopupmenu->insertItem("Download now",this,SLOT(popupDownloadNow())) ;
    downloadpopupmenu->insertItem("Play/Stop",this,SLOT(popupDownloadPlay())) ;
    downloadpopupmenu->insertSeparator();
    downloadpopupmenu->insertItem("Ping user",this,SLOT(popupPing()));
    downloadpopupmenu->insertItem("Whois user",this,SLOT(popupWhois()));

    downloadpopupmenu->insertSeparator();
    downloadpopupmenu->insertItem("terminate download",this,SLOT(popupDownloadTerminate()));
  }
  connect(downloadlistview,SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
       this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));

}
DownloadPanel::~DownloadPanel()
{
}

void DownloadPanel::popupPing()
{
  QListViewItem *selecteditem=downloadlistview->currentItem();

  if(selecteditem) {
     emit ping(selecteditem->text(DLV_USER));  //---------------
  }
}

void DownloadPanel::popupWhois()
{
  QListViewItem *selecteditem=downloadlistview->currentItem();

  if(selecteditem) {
     emit whois(selecteditem->text(DLV_USER));
  }
}
void DownloadPanel::popupDownloadPlay()
{
  QListViewItem *selecteditem=downloadlistview->currentItem();

  if(selecteditem) {
     // TODO ********* get the filename associated with this download
     emit play(selecteditem->text(DLV_FILE));
  }
}
void DownloadPanel::popupDownloadTerminate()
{
  QListViewItem *selecteditem=downloadlistview->currentItem();

  if(selecteditem) {
     emit terminate(selecteditem);
  }
}

void DownloadPanel::clear()
{
  downloadlistview->clear();
}

void DownloadPanel::popupMenu( QListViewItem *i, const QPoint &pos, int col)
{
  QListViewItem *selecteditem=i;
  // downloadlistview->currentItem();
  if(downloadpopupmenu && selecteditem) {
     downloadlistview->setSelected(selecteditem,true);
     downloadpopupmenu->exec(QCursor::pos());
  }
}

void DownloadPanel::addDownloadItem(SongInfo *song)
{
  if(!song) return;

  QString s_filename;
  if(!showdownloadpath) s_filename=getFileName(song->filename);
  else s_filename=song->filename;

  QListViewItem *i;

  // put the item in the listview
  i=new DownloadListItem(downloadlistview,
        getFileName(song->filename),
        QString().setNum(song->read),
        QString().setNum(song->size),
        QString().setNum(song->rate),
        song->user,
        convertDownloadStatus(song->status),
        "",
        song->md5);
}

void DownloadPanel::updateDownloadItem(SongInfo *sg)
{
  if(!sg) return;

  QString s_filename;
  if(!showdownloadpath) s_filename=getFileName(sg->filename);
  else s_filename=sg->filename;

  QListViewItem *it=downloadlistview->firstChild();

  while(it) {
     if(sg->md5.findRev(it->text(DLV_XTRA))==0) {
       it->setText(DLV_READ,QString().setNum(sg->read));
       it->setText(DLV_SIZE,QString().setNum(sg->size));
       it->setText(DLV_RATE,convertSize(sg->bps));
       it->setText(DLV_STATUS,convertDownloadStatus(sg->status)); // status
       it->setText(DLV_PROGRESS,"");
       break;
     }
     it=it->nextSibling();
  }

}

void DownloadPanel::removeDownloadItem(SongInfo *sg)
{
  if(!sg) return;

  QListViewItem *it=downloadlistview->firstChild();

  while(it) {
     if(sg->md5.findRev(it->text(DLV_XTRA))==0) {
       delete it; // found it
       break;
     }
     it=it->nextSibling();
  }
  return;
}

int DownloadPanel::numItems() const
{
  return downloadlistview->childCount();
}


bool DownloadPanel::showDownloadPath() const
{
  return showdownloadpath;
}
void DownloadPanel::setShowDownloadPath(bool yes)
{
  QString s_filename;

  if(showdownloadpath!=yes)
  {
/*
   QListViewItem *it=downloadlistview->firstChild();
    while(it) {
        if(!yes) s_filename=SearchPanel::getFileName(it->text(6));
        else s_filename=it->text(6);

        it->setText(0,s_filename);

        it=it->nextSibling();
    }
*/
    showdownloadpath=yes;
  }
  return;
}

// convert a number into equivalent status string
QString DownloadPanel::convertDownloadStatus(long s)
{
  QString str;
  switch(s) {
     case NapsterDownload::DL_FINISHED:
       str="Finished";
       break;
     case NapsterDownload::DL_INIT:
       str="Initializing";
       break;
     case NapsterDownload::DL_ERROR:
       str="Error";
       break;
     case NapsterDownload::DL_DOWNLOADING:
       str="Downloading";
       break;
     case NapsterDownload::DL_NOCONNECT:
       str="No connection";
       break;
     case NapsterDownload::DL_KILLED:
       str="Terminated";
       break;
     case NapsterDownload::DL_NOLOCALFILE:
       str="No file";
       break;
     case NapsterDownload::DL_QUEUED:
       str="Queued";
       break;
     default:
       str="??????";
  }
  return str;
}

