/***************************************************************************
                          uploadpanel.h  -  description
                             -------------------
    begin                : Sat Feb 5 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UPLOADPANEL_H
#define UPLOADPANEL_H

#include <qwidget.h>

class ExtListView;
class QListViewItem;
class QPopupMenu;
class SongInfo;

/**
  *@author John Donoghue
  */

class UploadPanel : public QWidget
{
   Q_OBJECT
signals:
  // sigs for popupmenu selections occuring
  void terminate(QListViewItem *);

  void play(const char *);

  void ping(const char *);
  void whois(const char *);
public slots:
  // clear the listview
  void clear();

private slots:
  void popupMenu( QListViewItem *, const QPoint &, int);

  void popupUploadPlay();
  void popupUploadTerminate();

  void popupPing();
  void popupWhois();

public: 
	UploadPanel(QWidget *parent=0, const char *name=0);
	virtual ~UploadPanel();

  void addUploadItem(SongInfo *song);
  void updateUploadItem(SongInfo *song);
  void removeUploadItem(SongInfo *song);

  int numItems() const;

  static QString convertUploadStatus(long s);

private:
  ExtListView *uploadlistview;
  QPopupMenu *uploadpopupmenu;
  bool showuploadpath;
};

#endif