/***************************************************************************
                          uploadpanel.cpp  -  description
                             -------------------
    begin                : Sat Feb 5 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uploadpanel.h"

#include <extlistview.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <kapp.h>
#ifdef KDE2
#include <klocale.h>
#endif /* KDE2 */

#include "support_funcs.h"

#include "songinfo.h"
#include "napsterupload.h"

#include <iostream.h>


UploadPanel::UploadPanel(QWidget *parent, const char *name )
: QWidget(parent,name)
{
  showuploadpath=true;

  QGridLayout *grid=new QGridLayout(this,1,1,5,5);
  uploadlistview=new ExtListView(this,"uploadview");
  uploadlistview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);

  grid->addMultiCellWidget(uploadlistview,0,0,0,0);

  // populate the header
  uploadlistview->addColumn(i18n("file"),200);
  uploadlistview->setColumnWidthMode(0,QListView::Manual);
  uploadlistview->addColumn(i18n("read"),80);
  uploadlistview->setColumnWidthMode(1,QListView::Manual);
  uploadlistview->addColumn(i18n("size"),80);
  uploadlistview->setColumnWidthMode(2,QListView::Manual);
  uploadlistview->addColumn(i18n("rate/s"),80);
  uploadlistview->setColumnWidthMode(1,QListView::Manual);
  uploadlistview->addColumn(i18n("user"),80);
  uploadlistview->setColumnWidthMode(3,QListView::Manual);
  uploadlistview->addColumn(i18n("status"),80);
  uploadlistview->setColumnWidthMode(4,QListView::Manual);

  uploadlistview->loadWidths();

  // create the popup menu for the uploadlist view
  uploadpopupmenu=new QPopupMenu();
  if(uploadpopupmenu) {
    uploadpopupmenu->insertItem(i18n("Play/Stop"),this,SLOT(popupUploadPlay())) ;
    uploadpopupmenu->insertSeparator();
    uploadpopupmenu->insertItem(i18n("Ping user"),this,SLOT(popupPing()));
    uploadpopupmenu->insertItem(i18n("Whois user"),this,SLOT(popupWhois()));

    uploadpopupmenu->insertSeparator();
    uploadpopupmenu->insertItem(i18n("terminate upload"),this,SLOT(popupUploadTerminate()));
  }
  connect(uploadlistview,SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
       this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));

}
UploadPanel::~UploadPanel()
{
}

/*
 * called from popupmenu for a ping
 */
void UploadPanel::popupPing()
{
  QListViewItem *selecteditem=uploadlistview->currentItem();

  if(selecteditem) {
     emit ping(selecteditem->text(4));  // let interested people know
  }
}

/*
 * on menu sel of whois
 */
void UploadPanel::popupWhois()
{
  QListViewItem *selecteditem=uploadlistview->currentItem();

  if(selecteditem) {
     emit whois(selecteditem->text(4));
  }
}
/*
 * on menu sel of play
 */
void UploadPanel::popupUploadPlay()
{
  QListViewItem *selecteditem=uploadlistview->currentItem();

  if(selecteditem) {
     emit play(selecteditem->text(0));
  }
}
/*
 * on menu sel of terminate
 */
void UploadPanel::popupUploadTerminate()
{
  QListViewItem *selecteditem=uploadlistview->currentItem();

  if(selecteditem) {
     emit terminate(selecteditem);
  }
}

/*
 * clear the items
 */
void UploadPanel::clear()
{
  uploadlistview->clear();
}

/*
 * on rmb select - show the menu if on an item
 */
void UploadPanel::popupMenu( QListViewItem *i, const QPoint &pos, int col)
{
  QListViewItem *selecteditem=i;

  if(uploadpopupmenu && selecteditem) {
     uploadlistview->setSelected(selecteditem,true);
     uploadpopupmenu->exec(QCursor::pos());
  }
}

/*
 * function to add song to the list
 */
void UploadPanel::addUploadItem(SongInfo *song)
{
  if(!song) return;

  // get name depending on if we want all of the name or not
  QString s_filename;
  if(!showuploadpath) s_filename=getFileName(song->filename);
  else s_filename=song->filename;

  QListViewItem *i;

#ifdef DEBUG_1
  cerr<<"add upload song item: "<<s_filename<<endl<<flush;
#endif

  // put the item in the listview
  i=new QListViewItem(uploadlistview,
        s_filename, //getFileName(song->filename),
        QString().setNum(song->read),
        QString().setNum(song->size),
        QString().setNum(song->rate),
        song->user,
        convertUploadStatus(song->status),
        song->md5);
}

/*
 * update the song with new data after finding it in the list
 */
void UploadPanel::updateUploadItem(SongInfo *sg)
{
  if(!sg) return;

  QString s_filename;
  if(!showuploadpath) s_filename=getFileName(sg->filename);
  else s_filename=sg->filename;

  QListViewItem *it=uploadlistview->firstChild();

  cerr<<"ul update: looking for "<<sg->filename<<" md5 " << sg->md5 << " ";

  // find the song - assuming the md5 is unique
  while(it) {
     if(sg->md5.findRev(it->text(6))==0) {
       cerr<<" found it ";
       it->setText(1,convertSize(sg->read));
       it->setText(2,convertSize(sg->size));
       it->setText(3,convertSize(sg->bps));
       it->setText(5,convertUploadStatus(sg->status));
       break;
     }
     it=it->nextSibling();
  }
  cerr<<endl<<flush;

}

/*
 * remove song from the list if it can be found
 */
void UploadPanel::removeUploadItem(SongInfo *sg)
{
  if(!sg) return;

  QListViewItem *it=uploadlistview->firstChild();

  while(it) {
     if(sg->md5.findRev(it->text(6))==0) {
       delete it; // found it
       break;
     }
     it=it->nextSibling();
  }
  return;
}

/*
 * get the number of items in the panel
 */
int UploadPanel::numItems() const
{
  return uploadlistview->childCount();
}

// convert a number into equivalent status string
QString UploadPanel::convertUploadStatus(long s)
{
  QString str;
  switch(s) {
     case NapsterUpload::DL_FINISHED:
       str="Finished";
       break;
     case NapsterUpload::DL_INIT:
       str="Initializing";
       break;
     case NapsterUpload::DL_ERROR:
       str="Error";
       break;
     case NapsterUpload::DL_DOWNLOADING:
       str="Uploading";
       break;
     case NapsterUpload::DL_NOCONNECT:
       str="No connection";
       break;
     case NapsterUpload::DL_KILLED:
       str="Terminated";
       break;
     case NapsterUpload::DL_NOLOCALFILE:
       str="No file";
       break;
     case NapsterUpload::DL_QUEUED:
       str="Queued";
       break;
     default:
       str="??????";
  }
  return str;
}
