/***************************************************************************
                          searchpanel.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "searchpanel.h"

#include <qpopupmenu.h>
#include <kapp.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcombo.h>
//#include <qlineedit.h>
#include <extlistview.h>
#include <extlineedit.h>
#include <qpushbutton.h>
#ifdef KDE2
#include <klocale.h>
#endif

#include "songinfo.h"
#include "support_funcs.h"
#include "extcombobox.h"

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

#include "speedvgood.xpm"
#include "speedgood.xpm"
#include "speedaverage.xpm"
#include "speedbad.xpm"


class SearchResultItem : public QListViewItem {
public:
  SearchResultItem(QListView *parent,const char *s1,const char *s2,const char *s3,
		   const char *s4,const char *s5,const char *s6,const char *s7)
    : QListViewItem(parent,s1,s2,s3,s4,s5,s6,s7)
  {
     int speed;

     if(s4) {
       speed = atoi(s4);
       /*
          show a kind of speed indicator - crap really as it is assuming
          that the user isn't lying about speed - this should be based on
          ping time
       */
       if(speed<1) setPixmap(0,QPixmap((const char **)speedbad_xpm));
       else if(speed<5) setPixmap(0,QPixmap((const char **)speedaverage_xpm));
       else if(speed<8) setPixmap(0,QPixmap((const char **)speedgood_xpm));
       else setPixmap(0,QPixmap((const char **)speedvgood_xpm));
     }
  }
#ifdef KDE2
  virtual QString text(int col) const
#else
  virtual const char *text(int col) const
#endif /* KDE2 */
  {
    static QString ret; // Copied on return from function so ok, even if ugly.
    if(col==1) {
      ret=convertSize(atol(QListViewItem::text(col)));
      return ret;
    }
    else if (col==3) {
      ret=convertSpeed(atoi(QListViewItem::text(col)));
      return ret;
    }
    else
      return QListViewItem::text(col);
  }
#ifdef KDE2
  virtual QString key(int col,bool asc) const
#else
  virtual const char *key(int col,bool asc) const
#endif /* KDE2 */
  {
    static QString ret;
    if(col==1) { // sort the size
        ret.sprintf( "%012ld", atol(QListViewItem::text(col)) );
        return ret;
    }
    else if(col==4) { // bitrate
        ret.sprintf( "%06ld", atoi(QListViewItem::text(col)) );
        return ret;
    }
    return QListViewItem::text(col);
  }
};

SearchPanel::SearchPanel(QWidget *parent, const char *name )
: QWidget(parent,name)
{
  int basewidth,maxw_sz;
                                   /* rows,cols , space,space*/
  QGridLayout *grid=new QGridLayout(this,4,6,5,5);

  QLabel *l=new QLabel(i18n("Search for "),this);
  maxw_sz =  l->sizeHint().width();

  grid->addWidget(l,0,0);

  searchoption=new QComboBox(false,this,"searchoption");
  searchoption->insertItem(i18n("TEXT IN TITLE"));
  searchoption->insertItem(i18n("USER"));
  searchoption->setMaximumSize( searchoption->sizeHint() );
  basewidth=searchoption->sizeHint().width();
  // all othe ctrls are based on this width

  grid->addWidget(searchoption,0,1);

  // we want to know when to ghost the other options
  connect(searchoption,SIGNAL(activated(int)),this,SLOT(searchComboActivated(int)));

  searchtext=new ExtComboBox(true,this,"searchtext");
  searchtext->setMaxCount(8);

  // return caught to start search
  connect(searchtext,SIGNAL(returnPressed()),this,SLOT(calcSearch()));

  grid->addMultiCellWidget(searchtext,0,0,2,4);

  // add search button
  searchbutton=new QPushButton(i18n("Search"),this,"searchbutton");
  searchbutton->setMaximumWidth( basewidth );
  connect(searchbutton,SIGNAL(clicked()),this,SLOT(calcSearch()));
  grid->addWidget(searchbutton,0,5);

  // the other search options
  l=new QLabel(i18n("Speed "),this);
  grid->addWidget(l,1,0);
  maxw_sz =  maxw_sz > l->sizeHint().width() ?
     maxw_sz : l->sizeHint().width();


  // create the speed combo
  speedoption=createCompareValueCB("speedoption");
  speedoption->setMaximumHeight( speedoption->sizeHint().height() );
  grid->addWidget(speedoption,1,1);
  connect(speedoption,SIGNAL(activated(int)),this,SLOT(optionComboActivated(int)));

  speedtext=new QComboBox(false,this,"speedtext");
  for(int i=0;i<=10;i++) {
    speedtext->insertItem( convertSpeed(i) );
  }
  speedtext->setMaximumWidth( basewidth );
  grid->addWidget(speedtext,1,2);

  l=new QLabel(i18n("Bitrate "),this);
  l->setAlignment(AlignRight);
  grid->addWidget(l,1,3);

  bitrateoption=createCompareValueCB("bitrateoption");
  bitrateoption->setMaximumWidth( basewidth );
  grid->addWidget(bitrateoption,1,4);
  connect(bitrateoption,SIGNAL(activated(int)),this,SLOT(optionComboActivated(int)));

  // the bitrate combo
  bitratetext=new QComboBox(false,this,"bitratetext");
  bitratetext->insertItem(i18n("64"));
  bitratetext->insertItem(i18n("74"));
  bitratetext->insertItem(i18n("96"));
  bitratetext->insertItem(i18n("112"));
  bitratetext->insertItem(i18n("128"));
  bitratetext->insertItem(i18n("160"));
  bitratetext->insertItem(i18n("192"));
  bitratetext->insertItem(i18n("256"));

  grid->addWidget(bitratetext,1,5);

  l=new QLabel(i18n("Frequency "),this);
  maxw_sz =  maxw_sz > l->sizeHint().width() ?
     maxw_sz : l->sizeHint().width();
  l->setMaximumWidth(maxw_sz);
  grid->addWidget(l,2,0);

  freqoption=createCompareValueCB("freqoption");
  freqoption->setMaximumHeight( freqoption->sizeHint().height() );
  grid->addWidget(freqoption,2,1);
  connect(freqoption,SIGNAL(activated(int)),this,SLOT(optionComboActivated(int)));

  // the freq combo
  freqtext=new QComboBox(false,this,"freqtext");
  freqtext->insertItem(i18n("11025"));
  freqtext->insertItem(i18n("22050"));
  freqtext->insertItem(i18n("44100"));
  freqtext->insertItem(i18n("48800"));

  grid->addWidget(freqtext,2,2);

  l=new QLabel(i18n("Max results "),this);
  l->setAlignment(AlignRight);
  grid->addWidget(l,2,3);

  resultstext=new ExtLineEdit(this,"resultstext");
  // only allows 100 in napster anyway - more are ignored
  resultstext->setMaxLength(3);
  resultstext->setText(i18n("100"));
  grid->addWidget(resultstext,2,4);

  // craete and populate the list
  searchlistview=new ExtListView(this,"searchview");
  searchlistview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  searchlistview->addColumn(i18n("file"),280);
  searchlistview->setColumnWidthMode(0,QListView::Manual);
  searchlistview->addColumn(i18n("size"),80);
  searchlistview->setColumnWidthMode(1,QListView::Manual);
  searchlistview->addColumn(i18n("frequency"),60);
  searchlistview->setColumnWidthMode(2,QListView::Manual);
  searchlistview->addColumn(i18n("speed"),80);
  searchlistview->setColumnWidthMode(3,QListView::Manual);
  searchlistview->addColumn(i18n("bitrate"));
  searchlistview->setColumnWidthMode(4,QListView::Manual);
  searchlistview->addColumn(i18n("user"),100);
  searchlistview->setColumnWidthMode(5,QListView::Manual);

  // sort on insertion  - on connection - ** was -1
  searchlistview->setSorting(3,false);

  // force a load of the saved list widths
  searchlistview->loadWidths();

  // default option is to allow multi selects
  multiselect =  true;
  searchlistview->setMultiSelection(true); // allow multi selects

  grid->addMultiCellWidget(searchlistview,3,3,0,5);

  // setup the menu popup

  searchpopupmenu=new QPopupMenu();
  if(searchpopupmenu) {
    searchpopupmenu->insertItem(i18n("Download file"),this,SLOT(popupSearchDownload()));
    searchpopupmenu->insertSeparator();
    searchpopupmenu->insertItem(i18n("Ping User"),this,SLOT(popupPing()));
    searchpopupmenu->insertItem(i18n("Whois this User"),this,SLOT(popupWhois()));

    searchpopupmenu->insertSeparator();
    searchpopupmenu->insertItem(i18n("Clear search list"),this,SLOT(clearSearch()));

    searchpopupmenu->insertSeparator();
    searchpopupmenu->insertItem("Toggle Show Path",this,SLOT(popupShowPath()));
  }
  connect(searchlistview,SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
       this,SLOT(popupSearch( QListViewItem *, const QPoint &, int )));

  // load in the last sessions search prefs
  loadSearchPrefs();

  // don't show paths as the default
  showsearchpath = false;
}
SearchPanel::~SearchPanel()
{
}

/*
 * time to do a search - create the search string and send to
 * interested people
 */
void SearchPanel::calcSearch()
{
  int type=searchoption->currentItem();
  const char *txt=searchtext->currentText();

  if(!txt || *txt=='\0') return;

   // make sure the text was saved in the combo list
   searchtext->saveText();


  if(type==0) {
    const char *m=resultstext->text();

    if(QString(m).toInt()<=0) m="100";

    QString tmp="FILENAME CONTAINS \"";

    tmp+=txt;
    tmp+="\" MAX_RESULTS ";
    tmp+=m;

    if(speedtext->isEnabled()) {
       tmp+=" LINESPEED \"";
       tmp+=speedoption->currentText();
       tmp+="\" ";
       tmp+= QString().setNum(speedtext->currentItem());
    }
    if(bitratetext->isEnabled()) {
       tmp+=" BITRATE \"";
       tmp+=bitrateoption->currentText();
       tmp+="\" \"";
       tmp+=bitratetext->currentText();
       tmp+="\"";

    }
    if(freqtext->isEnabled()) {
       tmp+=" FREQ \"";
       tmp+=freqoption->currentText();
       tmp+="\" \"";
       tmp+=freqtext->currentText();
       tmp+="\"";
    }
#ifdef DEBUG_1
    cerr<<"Sending query if: "<<tmp<<endl<<flush;
#endif
    emit search(type,tmp);

  }
  else emit search(type,txt);

  return;
}

/*
 * add a song to the search list
 */
void SearchPanel::addSearchItem(SongInfo *song)
{
  if(!song) return;

  QString s_filename;
  if(!showsearchpath) s_filename=getFileName(song->filename);
  else s_filename=song->filename;

  QListViewItem *i;

  // put the item in the listview
  // field 6 is invisible & holds the FULL path name of the song

  char buf[10];
  sprintf(buf,"%05d",song->speed);

  i=new SearchResultItem(searchlistview,
			 s_filename,
			 QString().setNum(song->size),
			 QString().setNum(song->freq),
			 buf,
			 QString().setNum(song->bitrate),
			 song->user,song->filename);

}

/*
 * time to popup the menu
 */
void SearchPanel::popupSearch( QListViewItem *i, const QPoint &pos, int col)
{
  QListViewItem *selecteditem=searchlistview->currentItem();
  if(searchpopupmenu && selecteditem) {
     searchpopupmenu->exec(QCursor::pos());
  }
}

void SearchPanel::clearSearch()
{
  searchlistview->clear();
}

/*
 * downlaod has been selected - request dload for each selected item
 */
void SearchPanel::popupSearchDownload()
{
  QListViewItem *item=searchlistview->firstChild();

  while(item) {
     if(item->isSelected()) {
        // selected so download it
        emit download(item);
        searchlistview->setSelected(item,false);
     }
     item = item->nextSibling();
  }
}

/*
 * menu selected for ping so ping all selected items
 */
void SearchPanel::popupPing()
{
  QListViewItem *item=searchlistview->firstChild();

  while(item) {
     if(item->isSelected()) {
        // selected so ping it
        emit ping(item->text(5));
     }
     item = item->nextSibling();
  }

}

/*
 * menu sel for who is - whois all selected
 */
void SearchPanel::popupWhois()
{
  QListViewItem *item=searchlistview->firstChild();

  while(item) {
     if(item->isSelected()) {
        // selected so whois it
        emit whois(item->text(5));
     }
     item = item->nextSibling();
  }
}

/*
 * get setting for if we wanted to show full apths or not
 */
bool SearchPanel::showSearchPath() const
{
  return showsearchpath;
}

/*
 * set whether to show full paths
 */
void SearchPanel::setShowSearchPath(bool yes)
{
  QString s_filename;

  // if setting has changed - we will have to go thru each one and change it
  if(showsearchpath!=yes)
  {
    QListViewItem *it=searchlistview->firstChild();
    while(it) {
        if(!yes) s_filename=getFileName(it->text(6));
        else s_filename=it->text(6);

        it->setText(0,s_filename);

        it=it->nextSibling();
    }

    showsearchpath=yes;
  }
  return;
}

/*
 * set whether to use multiselect or not
 */
void SearchPanel::setMultiSelect(bool yes)
{
  QString s_filename;

  if(multiselect!=yes)
  {
    // unselect all if not multi select????
    QListViewItem *item=searchlistview->firstChild();

    while(item) {
      if(item->isSelected())
        searchlistview->setSelected(item,false);
      item = item->nextSibling();
    }

    searchlistview->setMultiSelection(yes); // allow multi selects

    multiselect=yes;
  }
  return;
}

// slot for when the searchoption combo is cativated
// ( an item is selected/changed )
void SearchPanel::searchComboActivated(int v)
{
  if(v==1) { // search by user -> ghost all other options
     setExtraOptionsEnabled(false);
  }
  else { // otherwise unghost all options
     setExtraOptionsEnabled(true);
  }
  return;
}

// slot for when one of the other search option combos is cativated
// ( an item is selected/changed )
void SearchPanel::optionComboActivated(int v)
{
  // don't really care about the value here
  // setExtraOptionsEnabled will handle it
  setExtraOptionsEnabled(true);
  // we only get this msg if an option was enabled
}

// enable/disable the extra search options in the search panel
// NOTE: that even if enable is true, some widgets will only
// be enabled if their sibling widget allows them to be
// ie if speed option is Don't care, then the speed combo will always
// be disabled
void SearchPanel::setExtraOptionsEnabled(bool enable)
{

  speedoption->setEnabled(enable);
  bitrateoption->setEnabled(enable);
  freqoption->setEnabled(enable);

  resultstext->setEnabled(enable);

  speedtext->setEnabled( enable && speedoption->currentItem()!=0 );
  bitratetext->setEnabled( enable && bitrateoption->currentItem()!=0 );
  freqtext->setEnabled( enable && freqoption->currentItem()!=0 );

  return;
}

// creates a combo box with the items
// DONT CARE
// AT LEAST
// AT BEST
// EQUAL TO
QComboBox * SearchPanel::createCompareValueCB(const char *name)
{
  QComboBox *cb;

  cb=new QComboBox(false,this,name);
  cb->insertItem(i18n("DONT CARE"));
  cb->insertItem(i18n("AT LEAST"));
  cb->insertItem(i18n("AT BEST"));
  cb->insertItem(i18n("EQUAL TO"));

  return cb;
}

/*
 * menu sel for show paths - toggle it
 */
void SearchPanel::popupShowPath()
{
   setShowSearchPath(!showsearchpath);
}

// save / retrieve search lists from prefs
QStrList  SearchPanel::getSearchHistory()
{
   return searchtext->history();
}

/* set the search history from a string list */
void SearchPanel::setSearchHistory(const QStrList &str)
{
  searchtext->insertStrList(&str);
  searchtext->setEditText("");
  return;
}

/*
 * load in the search prefs from the config file
 */
void SearchPanel::loadSearchPrefs()
{
#ifdef KDE2
   KConfig *config = KGlobal::config();
#endif /* KDE2 */

  // set up the past history
  QStrList list(true);
#ifdef KDE2
  config->readListEntry ("history",list);
#else
  kapp->getConfig()->readListEntry ("history",list);
#endif

  setSearchHistory(list);

  setExtraOptionsEnabled(true);

#ifdef KDE2
  resultstext->setText(config->readEntry("search_results"));

  speedoption->setCurrentItem(config->readNumEntry("search_speedopt",0));
  bitrateoption->setCurrentItem(config->readNumEntry("search_bitrateopt",0));
  freqoption->setCurrentItem(config->readNumEntry("search_freqopt",0));

  freqtext->setCurrentItem(config->readNumEntry("search_freq",0));
  speedtext->setCurrentItem(config->readNumEntry("search_speed",0));
  bitratetext->setCurrentItem(config->readNumEntry("search_bitrate",0));

  searchoption->setCurrentItem(config->readNumEntry("search_type",0));

  setExtraOptionsEnabled(config->readNumEntry("search_type",0)==0);

#else
  resultstext->setText(kapp->getConfig()->readEntry("search_results"));

  speedoption->setCurrentItem(kapp->getConfig()->readNumEntry("search_speedopt",0));
  bitrateoption->setCurrentItem(kapp->getConfig()->readNumEntry("search_bitrateopt",0));
  freqoption->setCurrentItem(kapp->getConfig()->readNumEntry("search_freqopt",0));

  freqtext->setCurrentItem(kapp->getConfig()->readNumEntry("search_freq",0));
  speedtext->setCurrentItem(kapp->getConfig()->readNumEntry("search_speed",0));
  bitratetext->setCurrentItem(kapp->getConfig()->readNumEntry("search_bitrate",0));

  searchoption->setCurrentItem(kapp->getConfig()->readNumEntry("search_type",0));

  setExtraOptionsEnabled(kapp->getConfig()->readNumEntry("search_type",0)==0);
#endif
  return;
}
/*
 * save the prefs to the config for next time
 */
void SearchPanel::saveSearchPrefs()
{
     // save the past search history
    QStrList str = getSearchHistory();

#ifdef KDE2
   KConfig *config = KGlobal::config();
#endif /* KDE2 */

#ifdef KDE2
    config->writeEntry("history",str);
#else
    kapp->getConfig()->writeEntry("history",str);
#endif

#ifdef KDE2
  config()->writeEntry("search_freq",freqtext->currentItem());
  config()->writeEntry("search_speed",speedtext->currentItem());
  config()->writeEntry("search_bitrate",bitratetext->currentItem());

  config()->writeEntry("search_results",resultstext->text());

  config()->writeEntry("search_speedopt",speedoption->currentItem());
  config()->writeEntry("search_bitrateopt",bitrateoption->currentItem());
  config->writeEntry("search_freqopt",freqoption->currentItem());

  config->writeEntry("search_type",searchoption->currentItem());
#else
  kapp->getConfig()->writeEntry("search_freq",freqtext->currentItem());
  kapp->getConfig()->writeEntry("search_speed",speedtext->currentItem());
  kapp->getConfig()->writeEntry("search_bitrate",bitratetext->currentItem());

  kapp->getConfig()->writeEntry("search_results",resultstext->text());

  kapp->getConfig()->writeEntry("search_speedopt",speedoption->currentItem());
  kapp->getConfig()->writeEntry("search_bitrateopt",bitrateoption->currentItem());
  kapp->getConfig()->writeEntry("search_freqopt",freqoption->currentItem());

  kapp->getConfig()->writeEntry("search_type",searchoption->currentItem());
#endif
  return;
}

