/***************************************************************************
                          downloadpanel.h  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOWNLOADPANEL_H
#define DOWNLOADPANEL_H

#include <qwidget.h>

class ExtListView;
class QListViewItem;
class QPoint;
class QLabel;
class QPopupMenu;
class SongInfo;

/**the download panel
  *@author John Donoghue
  */

#define DLV_FILE     0
#define DLV_READ     1
#define DLV_SIZE     2
#define DLV_RATE     3
#define DLV_USER     4
#define DLV_STATUS   5
#define DLV_PROGRESS 6

#define DLV_XTRA     7 /* used to store the full filepath name */


class DownloadPanel : public QWidget  {
   Q_OBJECT
signals:
  // sigs for popupmenu selections occuring
  void terminate(QListViewItem *);

  void terminate_and_delete(QListViewItem *);

  void play(const char *);

  void ping(const char *);
  void whois(const char *);

public slots:
  // clear the listview
  void clear();

private slots:
  void popupMenu( QListViewItem *, const QPoint &, int);

  void popupDownloadPlay();
  void popupDownloadTerminate();
	
	void popupDownloadTerminateAndDelete();

  void popupPing();
  void popupWhois();

public: 
	DownloadPanel(QWidget *parent=0, const char *name=0);
	virtual ~DownloadPanel();

  void addDownloadItem(SongInfo *song);
  void updateDownloadItem(SongInfo *song);
  void removeDownloadItem(SongInfo *song);

  bool showDownloadPath() const;
  void setShowDownloadPath(bool yes);

  static QString convertDownloadStatus(long s);

  int numItems() const;

private:
  QPopupMenu *downloadpopupmenu;
  ExtListView *downloadlistview;
//  QLabel *stats;

  bool showdownloadpath;

};

#endif
