/***************************************************************************
                          napsterconnection.h  -  description
                             -------------------
    begin                : Sun Dec 5 1999
    copyright            : (C) 1999-2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NAPSTERCONNECTION_H
#define NAPSTERCONNECTION_H

/**
  *@author jade
  */

#include <iostream.h>
#include <string>

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// check for endianism
#if __BYTE_ORDER == __LITTLE_ENDIAN
// i386 type
 #define NAP_TO_SHORT(x) (x)
 #define NAP_TO_LONG(x)  (x)
 #define SHORT_TO_NAP(x) (x)
 #define LONG_TO_NAP(x)  (x)
#else
 // PPC  etc
 #define FIX_S(x) ( ((x&0xFF)<<8) | (x>>8) )
 #define FIX_L(x) ( ((x&0xFF)<<24) | ((x&0xFF00)<<8) | ((x&0xFF0000)>>8) | (x>>24) )

 #define NAP_TO_SHORT(x) FIX_S(x)
 #define NAP_TO_LONG(x)  FIX_L(x)
 #define SHORT_TO_NAP(x) FIX_S(x)
 #define LONG_TO_NAP(x)  FIX_L(x)

#endif

#define SERVER_ADDR "208.184.216.223" // default server for besthost
//#define SERVER_ADDR_2 "192.168.0.2"
//#define SERVER_ADDR_2 "208.178.163.58"

#define SERVER_PORT 8875

// server msg numbers
#define NAP_ERROR          0

#define NAP_LOGIN_REQ      2
#define NAP_LOGIN_RESULT   3
#define NAP_NEWUSERLOGIN_REQ  6
#define NAP_CREATEUSER_REQ 7
#define NAP_CREATEUSER_OK  8
#define NAP_CREATEUSER_ERROR 9    // couldn't create user
#define NAP_CREATEUSER_INVALIDNAME 10  // crap name given ie invalid chars & etc

//#define NAP_WHOISRESULT 92
//#define NAP_WHOISOFFLINE 93    ??????????

#define NAP_ADDTOSONGLIST_REQ 100

//#define NAP_DELETEFROMSONGLIST_REQ 101

#define NAP_SEARCH_REQ     200
#define NAP_SEARCH_RESULT   201
#define NAP_SEARCH_COMPLETE 202

#define NAP_DOWNLOAD_REQ   203
#define NAP_DOWNLOAD_RESULT 204

#define NAP_USER_MSG  205  // used for both send and retrieve

#define NAP_DOWNLOAD_ERROR 206

//#define NAP_ADDTOHOTLIST 207
//#define NAP_HOTLISTUSER_LOGGEDON 209
//#define NAP_HOTLISTUSER_LOGGEDOFF 210

#define NAP_BROWSE_ERROR   210 // NOTE: used also as hotlist user loggoff

#define NAP_BROWSE_REQ     211
#define NAP_BROWSE_RESULT   212
#define NAP_BROWSE_COMPLETE 213

// num files/songs etc on server
#define NAP_SERVER_STATS   214

#define NAP_DOWNLOAD_STARTED  218 // sent to notify the server
#define NAP_DOWNLOAD_FINISHED 219 // sent to notify the server

#define NAP_UPLOAD_STARTED  220 // sent to notify the server
#define NAP_UPLOAD_FINISHED 221 // sent to notify the server

//#define NAP_ADDTOHOTLIST_RESULT 301
//#define NAP_ADDTOHOTLIST_ERROR  302
//#define NAP_DELETEFROMHOTLIST  303

#define NAP_JOINCHAN_REQ   400
#define NAP_PARTCHAN_REQ   401
#define NAP_SENDCHAN_MSG   402
#define NAP_CHAN_MSG       403

#define NAP_ERROR_MSG		 	 404

#define NAP_JOINCHAN_RESULT 405

#define NAP_CHAN_USERJOINED 406
#define NAP_CHAN_USERLEFT 407

#define NAP_CHAN_USERINFO 408

#define NAP_CHAN_USERINFO_COMPLETE 409

#define NAP_CHAN_TOPIC 410 // topik data??

#define NAP_DOWNLOAD_REQ_NEW 500
//#define NAP_DOWNLOAD_NEW_RESULT 501

#define NAP_WHOIS_REQ      603
#define NAP_WHOIS_RESULT   604
#define NAP_WHOIS_NOTLOGGEDON 605

#define NAP_UPLOAD_REQ     607
#define NAP_UPLOAD_ALLOWED 608  // ????????????


#define NAP_CHANLIST_REQ    617
#define NAP_CHANLIST_RESULT 618

#define NAP_REMOTEQUEUEFULL 620
//#define NAP_NOT_CONNECTED  620 // ***** user not connected !!!!!!
                               // or is  206 the one??
                               // I think this may be something to do with
                               // the queue maybe?
#define NAP_SYSTEM_MSG     621

//#define NAP_MUZZLE_USER  622
//#define NAP_UNMUZZLE_USER  623

#define NAP_PING_REQ       751
#define NAP_PING_RESULT    752

#define NAP_SERVERVERSION_REQ 801

#define NAP_CHANUSERS_RESULT 825

#define NAP_CHANUSERS_REQ 830

// napster blocks of data
typedef struct _NapBlock {
  unsigned short size;
  unsigned short type;
  char data[2];
} __attribute__ ((packed)) NapBlock, *NAPBLOCKPTR;

class NapsterDownload;
class SongInfo;

class NapsterConnection
{
public:
  typedef enum {
         NAP_OK=0,NAP_BAD_PORT,NAP_BAD_IP,NAP_NO_CONNECT,
         NAP_NO_READ,NAP_NO_WRITE,
         NAP_SERVER_BUSY,NAP_NOSERVER_CONNECT,
         NAP_BAD_RECV_DATA,NAP_BAD_SEND_DATA,NAP_NO_LOGIN,
         NAP_NO_DOWNLOAD, NAP_NO_SOCKET,NAP_NO_BIND,
         NAP_NO_CREATEUSER,NAP_BAD_USERNAME,
         NAP_LAST } NapError;

	NapsterConnection();
	virtual ~NapsterConnection();

  // connect to host
  bool Connect(const char *username,const char *password,const char *email,
       int speed=0,int port=6699,bool new_user=false);

  bool getBestHost(const char *server=SERVER_ADDR);
  bool Connect(int port=6699); // assumes getBestHost was called
  bool Login(const char *username,const char *password,
        const char *email,int speed=0,bool new_user=false);

  void Disconnect();

  // status/info  funcs
  string getIPAddressString() const;
  int getIPPort() const;

  int getSocket() const;

  int getListener() const;

  bool isConnected() const { return (_connected==true); }
  bool haveHost() const { return _havehost==true; }

  NapError getLastError() const { return _lasterror; }

  const char *getLastErrorStr() const;

  // spawn a download session
  NapsterDownload *startDownload(long ip,int port,const char *filename,
       const char *user,int speed,const char *dest);

  // r/w functions
  NAPBLOCKPTR readBlock();
  int writeBlock(int type,const char *data,int size);

  const char *getBuffer();

  // shortcuts to do certain functions
  bool search(const char *name);

  bool search_user(const char *user);

  bool download(const char *name,const char *user);

  bool whois(const char *user);
  bool ping(const char *user);
  bool sendUserMessage(const char *user,const char *message);

  bool list();  // list channels available
  bool join(const char *chan);
  bool part(const char *chan);
  bool users(const char *chan);

  bool share(const SongInfo *s);

  bool sendChanMessage(const char *chan,const char *message);

  bool version();

  bool download_started_signal();
  bool download_finished_signal();

  bool upload_started_signal();
  bool upload_finished_signal();

private:
  int readComm(char *buffer,int size);
  int writeComm(const char *buffer,int size);
  bool setupListener(int _port);

private: // data
  char _buffer[2048];

  bool _connected;
  bool _havehost;

  // napster port etc and file handle
  struct sockaddr_in _sockaddr;
  int _napster;

  // the local listener for downloads
  int _local;
  int localportnum;

  NapError _lasterror;

  static const char *errorstr[];

};

#endif