/***************************************************************************
                          extcombobox.cpp  -  description
                             -------------------
    begin                : Mon Feb 28 2000
    copyright            : (C) 2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extcombobox.h"
#include <qkeycode.h>
#include <iostream.h>

#include <qstrlist.h>


ExtComboBox::ExtComboBox(QWidget *parent, const char *name )
: QComboBox(parent,name)
{
  lastchar=0;

  // we want to insert ourselves
  setInsertionPolicy(QComboBox::NoInsertion);

}

ExtComboBox::ExtComboBox(bool rw,QWidget *parent, const char *name )
: QComboBox(rw,parent,name)
{
  lastchar=0;
  setInsertionPolicy(QComboBox::NoInsertion);
}

ExtComboBox::~ExtComboBox()
{
}

void ExtComboBox::keyPressEvent ( QKeyEvent * e )
{
   QComboBox::keyPressEvent(e);

   // try to prevent the returnPress getting emitted 2x on a keystoke
   if(lastchar!=e->key() && (e->key()==Key_Return || e->key()==Key_Enter))
   {
      emit returnPressed();
      lastchar = e->key();

      saveText();
   }
   else if(lastchar==Key_Return || lastchar==Key_Enter)
     lastchar = 0;
   else lastchar = e->key();
}

/*void ExtComboBox::mousePressEvent ( QMouseEvent *e )
{
  QComboBox::mousePressEvent(e);
  lastchar = 0;
}*/

void ExtComboBox::saveText()
{
  /* add the value to the list - if its not there!!*/
  if(currentText()) {
    for(int i=0;i<count();i++) {
     // if we found a mtach dont add it
     if(text(i) && strcmp(currentText(),text(i))==0) return;
    }
    if(count()>0 && maxCount()-1 <= count()-1) {
      // remove one if we have to
      removeItem(count() - 1);
    }
    insertItem(currentText(),0);
  }
}

QStrList ExtComboBox::history()
{
   QStrList str(true); // copy the strings

   for(int i=0;i<count();i++) {
     // if we found a mtach dont add it
     str.append(text(i));
   }
   return str;
}
/*void ExtComboBox::setHistory(const QString &str)
{

}*/
