/***************************************************************************
                          consolepanel.cpp  -  description
                             -------------------
    begin                : Sat Jan 15 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "consolepanel.h"
#include <kapp.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qpainter.h>

#include <iostream.h>

#include "knapster.xpm"

#include "extlineedit.h"

/*
class MEdit : public QMultiLineEdit
{
public:
  MEdit(QWidget *parent=0,const char *name=0)
  : QMultiLineEdit(parent,name)
  {

  }
protected:
  virtual void paintCell ( QPainter * p, int row, int col )
  {
     QString *s = getString(row);
     cerr<<"paint line ("<<row<<") "<<s->data()<<endl<<flush;
     if(s->length()>0 && s->at(0)=='K') p->setPen(red);
     p->drawText(0,10,s->data());
     //QMultiLineEdit::paintCell(p,row,col);
  }
};
*/
ConsolePanel::ConsolePanel(QWidget *parent, const char *name )
: QWidget(parent,name)
{
  QGridLayout *grid=new QGridLayout(this,3,2,5,5);

  consolewin=new QMultiLineEdit(this);
  consolewin->setReadOnly(true);
  grid->addMultiCellWidget(consolewin,1,1,0,1);

  commandwin=new ExtLineEdit(this);
  commandwin->setMaximumHeight( commandwin->sizeHint().height() );
  connect(commandwin,SIGNAL(returnPressed()),this,SLOT(calcCommand()));
  grid->addMultiCellWidget(commandwin,2,2,0,1);

  QLabel *logo = new QLabel(this,"logo");
  logo->setPixmap(QPixmap((const char **)knapster));
  grid->addWidget(logo,0,1);
  logo->setMaximumSize(logo->sizeHint());

}
ConsolePanel::~ConsolePanel()
{
}

void ConsolePanel::writeString(QString s)
{
  if(!s.isNull()) {
    consolewin->insertLine(s);
    consolewin->setCursorPosition(consolewin->numLines(),0);
  }
  return;
}
void ConsolePanel::clear()
{
  consolewin->clear();
}
void ConsolePanel::calcCommand()
{
  const char *txt = commandwin->text();
  // if there is some text
  if(txt && *txt!='\0') {
    emit command(txt);
  }
  commandwin->clear();
}

