/***************************************************************************
                          ktmanagerimpl.h  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.11 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTMANAGERIMPL_H
#define KTMANAGERIMPL_H

#include <qdir.h>
#include <kurl.h>
#include "kcontainerimpl.h"
//#include "ktmanager.h"

class KTransferImpl;
class KTManager;

/**
 * @short Implementation of a manager for @ref KTransferImpl objects.
 * 
 * @author Sergio Moretti
 *
 * @version $Id: ktmanagerimpl.h,v 1.11 2001/03/15 19:32:01 sergio Exp $
 */

class KTManagerImpl : public KContainerImpl  
{
   Q_OBJECT

   friend class KTManager;
   friend class KObject;

public: 
   static const char DOCID[];
   static const char DOCTYPE[];

   virtual ~KTManagerImpl();

   /** document name */
   virtual const char * docId() const { return DOCID; }
   /** dom document type */
   virtual const char * docType() const { return DOCTYPE; }

   /** returns the manager's title */
   QString title() const { return _title; }
   /** sets the title of the manager */
   void setTitle(const QString &t);

   // items managements

   /** add a new transfer object */
   KTransferImpl * itemNew(int type, const KURL &rmt, const KURL &lcl);
   virtual void itemRemove(KObjectImpl *item);
   virtual bool isItemInsertable(const KObjectImpl *item);

   const KTManagerImpl * global() const;
   virtual void runPeriodically();
   /** get the current bandwidth */
   int bandwidth() const { return _bandwidth; }
   int mediumBandwidth() const { return _mediumBandwidth; }
   /** send a message to display */
   //void message(const QString &msg);

   /** scan transfer list to delete completed transfers */
   virtual void scanForRemoving();
   /** scan list to find a transfer to run */
   virtual KTransferImpl* selectForRunning(bool dLock, bool &runInFuture);

   // CONFIG
  
   /** return autodownload mode */
   bool getAutoDownload() const;
   /** enable/disable autodownload */
   void setAutoDownload(bool m=true);
   bool getAutoRemove() const;
   void setAutoRemove(bool r);
   int getMaxConnection() const;
   void setMaxConnection(int c);
   int getMaxBandwidth() const;
   void setMaxBandwidth(int b);
   int getMinBandwidth() const;
   void setMinBandwidth(int b);
   QString getLogFile() const;
   void setLogFile(const QString &l);
   /** directory containing file to process */
   virtual const QDir & getWorkingDir() const;
   /** set working directory */
   virtual void setWorkingDir(const QString &d);
   const QDir & getDownloadDir() const;
   void setDownloadDir(const QDir &d);
   int getDefaultType() const;
   void setDefaultType(int t);

protected:
   KTManagerImpl(int type);
   virtual KObjectImpl * clone() const { return new KTManagerImpl(type()); }

   virtual void loadData();
  
private: 
   // State
   /** global bandwidth */
   int _bandwidth;
   /** global medium bandwidth */
   int _mediumBandwidth;
   /** title */
   QString _title;
  
   // Configuration Parameters
   /** automatic downloading */
   bool _cfg_autoDownload;
   /** when transfer complete, remove entry */
   bool _cfg_autoRemove;
   /** max BPS bandwidth */
   int _cfg_maxBandwidth;
   /** min BPS bandwidth */
   int _cfg_minBandwidth;
   /** max open connection */
   int _cfg_maxConnection;
   /** write in log */
   QString _cfg_logFile;
   /** working directory */
   QDir _cfg_workingDir;
   /** download directory */
   QDir _cfg_downloadDir;
   /** default transfer type */
   int _cfg_defaultType;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
