/***************************************************************************
                           kmagodcopobj.cpp -
                         ---------------------------
    begin                : Thu Apr  5 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "kmago.h"
#include "kmagodcopobj.h"

KMagoDCOPObj::KMagoDCOPObj(QObject *parent, const char *name)
   : QObject(parent, name), DCOPObject("KMagoIface")
{
}

void KMagoDCOPObj::newWindow()
{
   kdDebug() << name() << ": newWindow" << endl;
   dynamic_cast<KMagoApp*>(KMagoApp::memberList->first())->slotFileNewWindow();
}

void KMagoDCOPObj::quit()
{
   kdDebug() << name() << ": quit" << endl;
   dynamic_cast<KMagoApp*>(KMagoApp::memberList->first())->slotFileQuit();
}

QValueList<DCOPRef> KMagoDCOPObj::appList()
{
   kdDebug() << name() << ": appList" << endl;
   QValueList<DCOPRef> lst;
   for (QListIterator<KMainWindow> it(*KMagoApp::memberList); it.current(); ++it)
      lst << DCOPRef(PACKAGE, it.current()->name());
   return lst;
}

QStringList KMagoDCOPObj::appListString()
{
   kdDebug() << name() << ": appListString" << endl;
   QStringList lst;
   for (QListIterator<KMainWindow> it(*KMagoApp::memberList); it.current(); ++it)
      lst << it.current()->name();
   return lst;
}

#include "kmagodcopobj.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
