/***************************************************************************
                           km.cpp - 
                         ---------------------------
    begin                : Wed Feb 14 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "km.h"

using namespace KM;

const ModFlags &KM::ANYMOD = initAnyMod();
const ModFlags &KM::CFGMOD = initCfgMod();


/////////// modification managements

void KM::setBit(int p, ModFlags &data)
{
   kdFatal(p < 0 || p >= MDI_NUM) << "p out of bound " << p << endl;
   data.setBit(p);
}

bool KM::getBit(int p, const ModFlags &data)
{
   kdFatal(p < 0 || p >= MDI_NUM) << "p out of bound " << p << endl;
   return data.testBit(p);
}

void KM::resetBits(ModFlags &data)
{
   data.fill(0);
}

void KM::orBits(const ModFlags &map, ModFlags &data)
{
   data |= map;
}

void KM::andBits(const ModFlags &map, ModFlags &data)
{
   data &= map;
}

bool KM::mapBits(const ModFlags &map, const ModFlags &data)
{
   for (int i = 0; i < MDI_NUM; ++i)
      if ((map.testBit(i) & data.testBit(i)) != 0)
	 return true;
   return false;
}

QString KM::bitsToString(const ModFlags &data)
{
   QString str;
   for (int i = 0; i < MDI_NUM; i += 32)
   {
      int v = 0;
      for (int j = i; (j < (i + 32)) && (j < MDI_NUM); ++j)
	 v += ((int)data.testBit(j) << (j - i));
      str += QString("%1").arg(v, 9, 16);
   }
   return str;
}

ModFlags KM::initAnyMod()
{
   ModFlags any(MDI_NUM);
   any.fill(1);
   return any;
}

ModFlags KM::initCfgMod()
{
   ModFlags any(MDI_NUM);
   any.fill(0);
   setBit(MDI_CFG_WORKINGDIR, any);
   setBit(MDI_CFG_PRPOLICY, any);
   setBit(MDI_CFG_MAXBAND, any);
   setBit(MDI_CFG_MINBAND, any);
   setBit(MDI_CFG_MAXCONN, any);
   setBit(MDI_TRN_CFG_CHKRESUME, any);
   setBit(MDI_TRN_CFG_MAXRESUME, any);
   setBit(MDI_TRN_CFG_AUTORESUME, any);
   setBit(MDI_TRN_CFG_WAITRESUME, any);
   setBit(MDI_TRN_CFG_WAITRETRY, any);
   setBit(MDI_TRN_CFG_MAXRETRY, any);
   setBit(MDI_TRN_CFG_LOGPROCESS, any);
   setBit(MDI_TRW_CFG_PASSIVE, any);
   setBit(MDI_TRW_CFG_CMDPATH, any);
   setBit(MDI_TRW_CFG_HTTPCACHE, any);
   setBit(MDI_TRW_CFG_RDTIMEOUT, any);
   setBit(MDI_TRW_CFG_PROXY, any);
   setBit(MDI_TRW_CFG_PROXYFTP, any);
   setBit(MDI_TRW_CFG_PROXYPORTFTP, any);
   setBit(MDI_TRW_CFG_PROXYHTTP, any);
   setBit(MDI_TRW_CFG_PROXYPORTHTTP, any);
   setBit(MDI_TRW_CFG_NOPROXYLST, any);
   setBit(MDI_TRW_CFG_SPEED, any);
   setBit(MDI_TRW_CFG_IGNLEN, any);
   setBit(MDI_TRK_CFG_COOKIE, any);
   setBit(MDI_TMN_CFG_AUTODWNL, any);
   setBit(MDI_TMN_CFG_AUTOREMOVE, any);
   setBit(MDI_TMN_CFG_LOGFILE, any);
   setBit(MDI_TMN_CFG_DWNLDIR, any);
   setBit(MDI_TMN_CFG_DFLTYPE, any);
   return any;
}

/* Local Variables: */
/* mode: c++ */
/* End: */
