/***************************************************************************
                          kcontainerview.cpp  -  description
                             -------------------
    begin                : Thu Dec 21 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.11 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qdragobject.h>
#include <qtextstream.h>
#include <kpopupmenu.h>
#include <qclipboard.h>
#include <kapp.h>
#include "kcntiterator.h"
//#include "kmagoview.h"
#include "kmagodoc.h"
#include "kcontainerview.h"

const char KContainerView::MIMETYPE[MimeTypeNum][50] =
{
   "application/" DOC "-TManager-list",
   "application/" DOC "-Transfer-list",
   "text/uri-list",
   "text/plain"
};

KContainerView::KContainerView(KMagoDoc *doc, Callback cb, KContainer c)
   : _doc(doc), _cnt(c), _callback(cb)
{
}

KContainerView::~KContainerView()
{
}

KMagoDoc * KContainerView::doc() const
{
   return _doc;
}

KMagoView * KContainerView::view() const
{
   return doc()->view();
}

KContainer KContainerView::container() const
{
   return _cnt;
}

void KContainerView::setContainer(KContainer c)
{
   _cnt = c;
   reset();
}

void KContainerView::reset()
{
   kdDebug(D_VIE) << name() << ": reset view" << endl;
   clear();
   if (container().isNull())
      return;
   for (KCntIterator it(container()); !it.current().isNull(); ++it)
      itemAdd(it.current());
}

bool KContainerView::dropItemList(KContainer source, KContainer target,
				  bool move, QDomDocument dom)
{
   // drop a list of items
   kdDebug(D_RUN) << "dropItemList : DOC #" << dom.toString() << "#" << endl;
   QDomElement e = dom.documentElement();
   if (e.attribute("Version") != DOCVERS)
   {
      kdDebug(D_RUN) << "dropItemList : version not correct" << endl;
      return false;
   }
   if ((target.itemType() & e.attribute("Type").toInt()) != target.itemType())
   {
      kdDebug(D_RUN) << "dropItemList : item type not handled by container" << endl;
      return false;
   }
   kdDebug(D_RUN) << "dropItemList : drop item-list " << e.attribute("Name") << endl;
   if (!source.isNull())
      kdDebug(D_RUN) << "dropItemList : source " << source.name() << endl;
   else
      kdDebug(D_RUN) << "dropItemList : source unknown" << endl;
   if (move)
   {
      //event->acceptAction(true);
      kdDebug(D_RUN) << "dropItemList : move" << endl;
   }
   else
   {
      //event->accept(true);
      kdDebug(D_RUN) << "dropItemList : copy" << endl;
   }
   kdDebug(D_RUN) << "dropItemList : target " << target.name() << endl;
   QDomNode n = e.firstChild();
   while (!n.isNull())
   {
      e = n.toElement();
      kdDebug(D_RUN) << "dropItemList : drop item " << e.attribute("Name") << endl;
      KObject item = target.itemCopy(e);
      kdWarning(item.isNull(), D_RUN) << "dropItemList : error creating item" << endl;
      if (!item.isNull())
      {
	 kdDebug(D_RUN) << "dropItemList : create " << item.name() << endl;
	 if (move)
	 {
	    kdDebug(D_RUN) << "dropItemList : remove " << e.attribute("Id") << endl;
	    //source.itemRemove(source.itemFindId(e.attribute("Id").toInt()));
	    KObject itemToRemove = source.itemSearch(e.attribute("Id").toInt());
	    itemToRemove.container().itemRemove(itemToRemove);
	 }
      }
      n = n.nextSibling();
   }
   //main()->resetView(); //FIXME is really needed?
   target.emitMod();
   if (move)
      source.emitMod();
   return true;
}

bool KContainerView::dropUriList(KMagoDoc *doc, KContainer target,
				 QStrList &uris)
{
   kdDebug(D_RUN) << "dropUriList: " << endl;
   for (char *uri = uris.first(); uri != 0; uri = uris.next())
      doc->addTransfer(uri, target.toTManager());
   return true;
}

bool KContainerView::dropText(KMagoDoc *doc, KContainer target,
			      const QString &text)
{
   kdDebug(D_RUN) << "dropText : TEXT=" << text << endl;
   QString buf = text;
   QTextIStream s(&buf);
   QString line;
   while (!s.atEnd())
   {
      s >> line;
      doc->addTransfer(line, target.toTManager());
   }
   return true;
}

bool KContainerView::acceptDrop(const QDropEvent *event, KContainer target)
{
   KContainer source;
   if (dynamic_cast<KContainerView*>(event->source()) != 0)
      source = dynamic_cast<KContainerView*>(event->source())->container();
   else
      return true;
   //FIXME!! aggiungi se target.isChildOf(source)
   if (source == target)
   {
      //kdWarning(D_RUN) << target.name() << ": drop on source" << endl;
      return false;
   }
   /*
     if (source.itemActiveCount() > 0) {
     kdWarning(D_RUN) << target.name() << ": drop source active" << endl;
     return false;
     }
   */
   return true;
}

void KContainerView::dropTransferList(QDropEvent *event, KMagoDoc *doc,
				      KContainer target)
{
   if (!acceptDrop(event, target))
   {
      event->ignore();
      return;
   }
   if (event->provides(MIMETYPE[MimeTransferList]))
   {
      QDomDocument dom("item-list");
      if (!dom.setContent(event->encodedData(MIMETYPE[MimeTransferList])))
      {
	 kdWarning(D_RUN) << "dropTransferList : error decoding transfer-list " << dom.toString() << endl;
	 event->ignore();
	 return;
      }
      KContainer source;
      if (dynamic_cast<KContainerView*>(event->source()) != 0)
	 source = dynamic_cast<KContainerView*>(event->source())->container();
      event->acceptAction(dropItemList(source, target, event->action() == QDropEvent::Move && !source.isNull(), dom));
   }
   else if (event->provides(MIMETYPE[MimeUriList]))
   {
      QStrList lst;
      if (QUriDrag::decode(event, lst))
	 event->accept(dropUriList(doc, target, lst));
      else
	 event->ignore();
   }
   else if (event->provides(MIMETYPE[MimeText]))
   {
      QString text;
      //FIXME error in QTextDrag::decode
      //kdDebug() << "TEXT DATA=" << QString(event->encodedData("text/plain")) << endl;
      text = QString(event->encodedData(MIMETYPE[MimeText]));
      event->accept(dropText(doc, target, text));
      /*
      if (QTextDrag::decode(event, text))
	 event->accept(dropText(doc, target, text));
      else
         event->ignore();
      */
   }
   else
      event->ignore();
}

void KContainerView::dropTManagerList(QDropEvent *event, KContainer target)
{
   if (!acceptDrop(event, target))
   {
      event->ignore();
      return;
   }
   /*
  for (QValueList<QIconDragItem>::ConstIterator i = lst.begin(); i != lst.end(); ++i) {
    QString id;
    QTextIStream((*i).data()) >> id;
    kdDebug(D_RUN) << name() << ": drop item " << id << endl;
  }
  */
   if (event->provides(MIMETYPE[MimeTManagerList]))
   {
      QDomDocument dom("item-list");
      if (!dom.setContent(event->encodedData(MIMETYPE[MimeTManagerList])))
      {
	 kdWarning(D_RUN) << "dropTManagerList : error decoding tmanager-list" << dom.toString() << endl;
	 event->ignore();
	 return;
      }
      KContainer source;
      if (dynamic_cast<KContainerView*>(event->source()) != 0)
	 source = dynamic_cast<KContainerView*>(event->source())->container();
      event->acceptAction(dropItemList(source, target, event->action() == QDropEvent::Move && !source.isNull(), dom));
   }
   else
      event->ignore();
}

bool KContainerView::transferCanDecode(const QMimeSource *e)
{
   bool retval = (e->provides(MIMETYPE[MimeTransferList])
		  || e->provides(MIMETYPE[MimeUriList])
		  || e->provides(MIMETYPE[MimeText])
      );
   if (!retval)
   {
      const char *fmt;
      QString ln;
      for (int i = 0; ; ++i)
      {
	 fmt = e->format(i);
	 if (fmt == 0)
	    break;
	 ln += QString(" : ") + fmt;
      }
      kdDebug(D_RUN) << ": transferCanDecode " << ln << endl;
   }
   return retval;
}

bool KContainerView::managerCanDecode(const QMimeSource *e)
{
   return (e->provides(MIMETYPE[MimeTManagerList])
	   || e->provides(MIMETYPE[MimeTransferList])
	   || e->provides(MIMETYPE[MimeUriList])
      );
}

QByteArray KContainerView::managerEncodedData(const KTManager::List &mngrs,
					      const char* mimetype)
{
   QByteArray data;
   QTextStream s(data, IO_WriteOnly);
   if (strcmp(mimetype, MIMETYPE[MimeTManagerList]) == 0)
   {
      s << "<?xml version = '1.0'?><!DOCTYPE item-list >"
	<< "<item-list Version=\"" << DOCVERS
	<< "\" Type=\"" << TYP_TMANAGER_T << "\">" << endl;
      for (KTManager::List::ConstIterator i = mngrs.begin();
	   i != mngrs.end(); ++i)
	 (*i).dom().save(s, 1);
      s << "</item-list>" << endl;
   }
   else if (strcmp(mimetype, MIMETYPE[MimeTransferList]) == 0)
   {
      s << "<?xml version = '1.0'?><!DOCTYPE item-list >"
	<< "<item-list Version=\"" << DOCVERS
	<< "\" Type=\"" << TYP_FILE_TRANSFER_T << "\">" << endl;
      for (KTManager::List::ConstIterator i = mngrs.begin();
	   i != mngrs.end(); ++i)
	 for (KCntIterator it(*i); !it.current().isNull(); ++it)
	    it.current().dom().save(s, 1);
      s << "</item-list>" << endl;
   }
   else if (strcmp(mimetype, MIMETYPE[MimeUriList]) == 0)
   {
      QStrList lst;
      for (KTManager::List::ConstIterator i = mngrs.begin();
	   i != mngrs.end(); ++i)
	 for (KCntIterator it(*i); !it.current().isNull(); ++it)
	    lst.append(QUriDrag::unicodeUriToUri(it.current().toTransfer().remote().url())); //FIXME??
      data = QUriDrag(lst, 0).encodedData("text/uri-list");
   }
   else
   {
      kdFatal(D_RUN) << "managerEncodedData : UNKNOWN MIME" << endl;
   }
   return data;
}

QByteArray KContainerView::transferEncodedData(const KTransfer::List &trns,
					       const char* mimetype)
{
   QByteArray data;
   QTextStream s(data, IO_WriteOnly);
   if (strcmp(mimetype, MIMETYPE[MimeTransferList]) == 0)
   {
      s << "<?xml version = '1.0'?><!DOCTYPE item-list >"
	<< "<item-list Version=\"" << DOCVERS
	<< "\" Type=\"" << TYP_FILE_TRANSFER_T << "\">" << endl;
      for (KTransfer::List::ConstIterator i = trns.begin(); i != trns.end(); ++i)
	 (*i).dom().save(s, 1);
      s << "</item-list>" << endl;
   }
   else if (strcmp(mimetype, MIMETYPE[MimeUriList]) == 0)
   {
      for (KTransfer::List::ConstIterator i = trns.begin(); i != trns.end(); ++i)
	 s << (*i).remote().url() << endl;
   }
   else
   {
      kdFatal(D_RUN) << "transferEncodedData : UNKNOWN MIME" << endl;
   }
   return data;
}

const char* KContainerView::managerFormat(int i)
{
   //kdDebug(D_RUN) << "managerFormat : drag format " << i << endl;
   switch (i)
   {
   case 0: return MIMETYPE[MimeTManagerList];
   case 1: return MIMETYPE[MimeTransferList];
   case 2: return MIMETYPE[MimeUriList];
   }
   return 0;
}

const char* KContainerView::transferFormat(int i)
{
   //kdDebug(D_RUN) << "transferFormat : drag format " << i << endl;
   switch (i)
   {
   case 0: return MIMETYPE[MimeTransferList];
   case 1: return MIMETYPE[MimeUriList];
   }
   return 0;
}

bool KContainerView::transferDragEnabled(KTransfer t)
{
   return (!t.isNull() && !t.isRunning());
}

bool KContainerView::managerDragEnabled(KTManager m)
{
   return (!m.isNull() && m.itemActiveCount() == 0
	   && m.container().itemCount() > 1);
}

KTManager KContainerView::selectManager(KMagoDoc *doc)
{
   KPopupMenu *mngrList = new KPopupMenu(kapp->mainWidget());
   //mngrList->insertTitle(i18n("Select Manager"));
   for (KCntIterator it(doc->manager()); !it.current().isNull(); ++it)
      mngrList->insertItem(it.current().toTManager().title());
   mngrList->insertSeparator();
   int cancid = mngrList->insertItem(i18n("Cancel"));
   int id = mngrList->exec(QCursor::pos());
   if (id == cancid)
      return KTManager::null();
   return doc->manager().itemAt(mngrList->indexOf(id)).toTManager();
}

bool KContainerView::managerToClipboard(KTManager m, bool cut)
{
   if (!managerDragEnabled(m))
      return false;
   QString text;
   QTextOStream s(&text);
   for (KCntIterator it(m); !it.current().isNull(); ++it)
      s << it.current().toTransfer().remote().url() << endl;
   kapp->clipboard()->setData(new QTextDrag(text, kapp->mainWidget()));
   if (cut)
      m.container().itemRemove(m);
   return true;
}

bool KContainerView::transferToClipboard(KTransfer t, bool cut)
{
   if (!transferDragEnabled(t))
      return false;
   kapp->clipboard()->setData(new QTextDrag(t.remote().url(),
					    kapp->mainWidget()));
   if (cut)
      t.container().itemRemove(t);
   return true;
}

bool KContainerView::managersPasteFromClipboard(KMManager m)
{
   QMimeSource *mime = kapp->clipboard()->data();
   if (!mime->provides(MIMETYPE[MimeTManagerList]))
      return false;
   QDomDocument dom("item-list");
   if (!dom.setContent(mime->encodedData(MIMETYPE[MimeTManagerList])))
   {
      kdWarning(D_RUN) << ": managersPasteFromClipboard: error decoding item-list" << dom.toString() << endl;
      return false;
   }
   return dropItemList(KContainer::null(), m, false, dom);
}

bool KContainerView::transfersPasteFromClipboard(KTManager m)
{
   QMimeSource *mime = kapp->clipboard()->data();
   if (!mime->provides(MIMETYPE[MimeTransferList]))
      return false;
   QDomDocument dom("item-list");
   if (!dom.setContent(mime->encodedData(MIMETYPE[MimeTransferList])))
   {
      kdWarning(D_RUN) << ": transfersPasteFromClipboard : error decoding item-list " << dom.toString() << endl;
      return false;
   }
   return dropItemList(KContainer::null(), m, false, dom);
}

bool KContainerView::urisPasteFromClipboard(KMagoDoc *doc)
{
   QMimeSource *mime = kapp->clipboard()->data();
   if (!mime->provides(MIMETYPE[MimeUriList]))
      return false;
   QStrList lst;
   if (!QUriDrag::decode(mime, lst))
   {
      kdWarning(D_RUN) << ": urisPasteFromClipboard : paste uris: decode fail" << endl;
      return false;
   }
   return dropUriList(doc, doc->currentManager(), lst);
}

bool KContainerView::textsPasteFromClipboard(KMagoDoc *doc)
{
   QMimeSource *mime = kapp->clipboard()->data();
   if (!mime->provides(MIMETYPE[MimeText]))
      return false;
   QString text;
   if (!QTextDrag::decode(kapp->clipboard()->data(), text))
   {
      kdWarning(D_RUN) << ": textsPasteFromClipboard : paste text: decode fail" << endl;
      return false;
   }
   return dropText(doc, doc->currentManager(), text);
}

////////////////////////////////////////////////////////////////////

KTransferListDrag::KTransferListDrag(QWidget *dragSource, const char *name)
   : QDragObject(dragSource, name)
{
}

const char* KTransferListDrag::format(int i) const
{
   return KContainerView::transferFormat(i);
}

QByteArray KTransferListDrag::encodedData(const char* mimetype) const
{
   return KContainerView::transferEncodedData(trns, mimetype);
}

bool KTransferListDrag::canDecode(const QMimeSource *e)
{
   return KContainerView::transferCanDecode(e);
}

void KTransferListDrag::append(KTransfer t)
{
   trns << t;
}

////////////////////////////////////////////////////////////////////

KTManagerListDrag::KTManagerListDrag(QWidget *dragSource, const char *name)
   : QDragObject(dragSource, name)
{
}

const char* KTManagerListDrag::format(int i) const
{
   return KContainerView::managerFormat(i);
}

QByteArray KTManagerListDrag::encodedData(const char* mimetype) const
{
   return KContainerView::managerEncodedData(mngrs, mimetype);
}

bool KTManagerListDrag::canDecode(const QMimeSource *e)
{
   return KContainerView::managerCanDecode(e);
}

void KTManagerListDrag::append(KTManager m)
{
   mngrs << m;
}

#include "kcontainerview.moc"
