/***************************************************************************
                          utils.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.8 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfileinfo.h>

/**
 * transfer inserting prompt flags
 */
enum AskMode {
  ASK_IFEXIST,
  ASK_IFNOTEXIST,
  DONT_ASK
};

bool checkFilePermission(const QFileInfo &file);
bool checkFileCreation(const QFileInfo &file);
bool promptFileCreate(const QFileInfo &file);
bool promptFileOverwrite(const QFileInfo &file);
bool prompFileOpen(const QFileInfo &file, int mod = 0);
/** open a message box with the prompt for the add mode */
int promptStartMode(const QString &caption, const QString &message);
/** select which file to recover */
int promptFilesToRecover(const QString &f1, const QString &f2);
/** prompt to recover file */
int promptFileToRecover(const QString &f);
/** create a tmp filename */
QString tempFile();
/** transform a number of type 100,000 to 100000*/
int parseNumber(const QString& num);
/** save a file moving it to file.NN */
QString saveFile(const QString &file);
/** get normalized number */
QString unit(float val);
/** copy file source to dest */
bool copyFile(const QString &source, const QString &dest);
/** true if app is running as unique */
bool isUniqueApp();
/** true if app is running as single-document */
bool isSingleDoc();
//uint mem();

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
