/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.17 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kuniqueapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kstddirs.h>

#include "kmago.h"
#include "kmagodoc.h"

static const char *description = I18N_NOOP("The KDE MAnager of Get Operations - A download manager.");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE

bool _uniqueApp;
bool _singleDoc;

static KCmdLineOptions options[] =
{
   { "+[File]", I18N_NOOP("file to open"), 0 },
   { "n", 0, 0 },
   { "new-document", I18N_NOOP("open a new temporary document"), 0 },
   { "u", 0, 0 },
   { "unique", I18N_NOOP("run as unique application"), 0 },
   { "s", 0, 0 },
   { "single-doc", I18N_NOOP("run as unique app, using ~/.kde/share/apps/kmago/data as document"), 0},
   { "enable-exit-on-idle", I18N_NOOP("exit if no transfers are left to run"), 0},
   { "disable-exit-on-idle", I18N_NOOP("don't exit if no transfers are left to run"), 0},
   { "enable-execute-on-idle", I18N_NOOP("execute command when no transfers are left to run"), 0},
   { "disable-execute-on-idle", I18N_NOOP("don't execute command when no transfers are left to run"), 0},
   { "enable-download-lock", I18N_NOOP("enable download locking"), 0},
   { "disable-download-lock", I18N_NOOP("disable download locking"), 0},
   { "enable-notify", I18N_NOOP("enable events notifications"), 0},
   { "disable-notify", I18N_NOOP("disable events notifications") , 0},
   { 0, 0, 0 }
   // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{
   KAboutData aboutData( "kmago", I18N_NOOP("KMago"),
			 VERSION, description, KAboutData::License_GPL,
			 "(c) 2000, Sergio Moretti",
			 0,
			 "http://kmago.sourceforge.net",
			 "sermore@users.sourceforge.net");
   aboutData.addAuthor("Sergio Moretti",0, "sermore@libero.it");
   KCmdLineArgs::init( argc, argv, &aboutData );
   KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

   KUniqueApplication::addCmdLineOptions();

   KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
   int retval = 0;
   KApplication *app = 0;
   bool ok = true;

   // set global values
   _uniqueApp = args->isSet("unique") || args->isSet("single-doc");
   _singleDoc = args->isSet("single-doc");

   if (_uniqueApp)
   {
      if (!KUniqueApplication::start()) {
	 fprintf(stderr, "kmago is already running!\n");
	 return -1;
      }
      app = new KUniqueApplication();
   }
   else
   {
      app = new KApplication();
   }

   if (app->isRestored())
   {
      //RESTORE(KMagoApp);
      int n = 1;
      while (KMainWindow::canBeRestored(n))
      {
	 (new KMagoApp(true))->restore(n, false);
	 n++;
      }
   }
   else
   {
      KMagoApp *kmago = new KMagoApp();
      kmago->show();

      if (args->isSet("single-doc"))
	 ok = kmago->doc()->open(locateLocal("appdata", "data"));
      else if (args->isSet("new-document"))
	 ok = kmago->doc()->openNew();
      else if (args->count())
	 ok = kmago->doc()->open(args->arg(0));
      else if (kmago->doc()->getLoadLastDoc())
	 ok = kmago->doc()->openLastUsed();
      else
	 ok = kmago->doc()->openNew();

      if (args->isSet("enable-exit-on-idle"))
	 kmago->setExitOnIdle(true);
      if (args->isSet("disable-exit-on-idle"))
	 kmago->setExitOnIdle(false);

      if (args->isSet("enable-execute-on-idle"))
	 kmago->setExecuteOnIdle(true);
      if (args->isSet("disable-execute-on-idle"))
	 kmago->setExecuteOnIdle(false);

      if (args->isSet("enable-download-lock"))
	 kmago->setDownloadLock(true);
      if (args->isSet("disable-download-lock"))
	 kmago->setDownloadLock(false);

      if (args->isSet("enable-notify"))
	 kmago->doc()->setEnableNotify(true);
      if (args->isSet("disable-notify"))
	 kmago->doc()->setEnableNotify(false);
   }
   args->clear();

   if (ok)
      retval = app->exec();

   fprintf(stderr, "fine!\n");

   delete app;

   return retval;
}
