/***************************************************************************
                          ktransferwget.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.12 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFERWGET_H
#define KTRANSFERWGET_H

#include "ktransfer.h"

class KTManager;
class KTransferWgetImpl;

/**
 * @short Bridge class for @ref KTransferWgetImpl objects.
 * 
 * @author Sergio Moretti
 *
 * @version $Id: ktransferwget.h,v 1.12 2001/03/05 20:59:23 sergio Exp $
 */

class KTransferWget : public KTransfer 
{
   friend class KObject;
   friend class KTManager;
  
public:
   /** create empty transfer */
   KTransferWget() {}

   // config attributes
  
   /** get wget command path */
   QString getCmdPath() const;
   /** set wget command path */
   void setCmdPath(const QString &c);
   /** use passive transfer mode */
   bool getPassiveFtp() const;
   /** set passive transfer mode */
   void setPassiveFtp(bool p);
   int getReadTimeout() const;
   void setReadTimeout(int t);
   bool getHTTPCache() const;
   void setHTTPCache(bool m);
   bool getProxy() const;
   void setProxy(bool m);
   QString getProxyFTP() const;
   void setProxyFTP(const QString &p);
   QString getProxyHTTP() const;
   void setProxyHTTP(const QString &p);
   int getProxyPortFTP() const;
   void setProxyPortFTP(int p);
   int getProxyPortHTTP() const;
   void setProxyPortHTTP(int p);
   QStringList getNoProxyList() const;
   void setNoProxyList(const QStringList &l);
   TransferSpeed getSpeed() const;
   void setSpeed(TransferSpeed s);
   bool getIgnoreLength() const;
   void setIgnoreLength(bool v);

protected:
   KTransferWget(KTransferWgetImpl *impl);
   KTransferWgetImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
