/***************************************************************************
                          ktransfer.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.26 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktransferimpl.h"
#include "ktmanager.h"
#include "ktransfer.h"


const KURL & KTransfer::local() const
{
   return impl()->local();
}

void KTransfer::setLocal(const KURL &lcl) const
{
   impl()->setLocal(lcl);
}

const KURL & KTransfer::remote() const
{
   return impl()->remote();
}

void KTransfer::setRemote(const KURL &rmt) const
{
   impl()->setRemote(rmt);
}

const KURL & KTransfer::tmp() const
{
   return impl()->tmp();
}

void KTransfer::setTmp(const KURL &tmp) const
{
   impl()->setTmp(tmp);
}

int KTransfer::len() const
{
   return impl()->len();
}

void KTransfer::setLen(int l) const
{
   impl()->setLen(l);
}

int KTransfer::partial() const
{
   return impl()->partial();
}

int KTransfer::percent() const
{
   return impl()->percent();
}

int KTransfer::resumed() const
{
   return impl()->resumed();
}

void KTransfer::setResumed(int r) const
{
   impl()->setResumed(r);
}

void KTransfer::setRsmState(RsmState s) const
{
   impl()->setRsmState(s);
}

int KTransfer::retry() const
{
   return impl()->retry();
}

TrnState KTransfer::state() const
{
   return impl()->state();
}

void KTransfer::setState(TrnState s) const
{
   impl()->setState(s);
}

RsmState KTransfer::rsmState() const
{
   return impl()->rsmState();
}

int KTransfer::bandwidth() const
{
   return impl()->bandwidth();
}

int KTransfer::mediumBandwidth() const
{
   return impl()->mediumBandwidth();
}

QTime KTransfer::startTime() const
{
   return impl()->startTime();
}

QString KTransfer::progressStr() const
{
   return impl()->progressStr();
}

QString KTransfer::stateStr() const
{
   return impl()->stateStr();
}

QString KTransfer::stateStr(TrnState s) // static
{
   return KTransferImpl::stateStr(s);
}

QString KTransfer::resumeStr() const
{
   return impl()->resumeStr();
}

QString KTransfer::resumeStr(RsmState s) // static
{
   return KTransferImpl::resumeStr(s);
}

QString KTransfer::resumeString(RsmState s) // static
{
   return KTransferImpl::resumeString(s);
}

bool KTransfer::isProtocolSupported(const QString &proto) const
{
   return impl()->isProtocolSupported(proto);
}

bool KTransfer::isComplete() const
{
   return impl()->isComplete();
}

bool KTransfer::isFinished() const
{
   return impl()->isFinished();
}

bool KTransfer::isReady() const
{
   return impl()->isReady();
}

bool KTransfer::isRunnable(bool automatic) const
{
   return impl()->isRunnable(automatic);
}

bool KTransfer::isResumable() const
{
   return impl()->isResumable();
}

QTime KTransfer::estTime() const
{
   return impl()->estTime();
}

KURL KTransfer::getTempFile(const KURL &rmt, const KURL &lcl) const
{
   return impl()->getTempFile(rmt, lcl);
}

void KTransfer::clear() const
{
   impl()->clear();
}

void KTransfer::resetState() const
{
   impl()->resetState();
}

bool KTransfer::stop(bool wait) const
{
   return impl()->stop(wait);
}

bool KTransfer::startCheckResume() const
{
   return impl()->startCheckResume();
}

// CONFIG

bool KTransfer::getCheckResume() const
{
   return impl()->getCheckResume();
}

void KTransfer::setCheckResume(bool c) const
{
   impl()->setCheckResume(c);
}

int KTransfer::getMaxResume() const
{
   return impl()->getMaxResume();
}

void KTransfer::setMaxResume(int r) const
{
   impl()->setMaxResume(r);
}

bool KTransfer::getAutoResume() const
{
   return impl()->getAutoResume();
}

void KTransfer::setAutoResume(bool m) const
{
   impl()->setAutoResume(m);
}

int KTransfer::getWaitResume() const
{
   return impl()->getWaitResume();
}

void KTransfer::setWaitResume(int w) const
{
   impl()->setWaitResume(w);
}

int KTransfer::getMaxRetry() const
{
   return impl()->getMaxRetry();
}

void KTransfer::setMaxRetry(int m) const
{
   impl()->setMaxRetry(m);
}

int KTransfer::getWaitRetry() const
{
   return impl()->getWaitRetry();
}

void KTransfer::setWaitRetry(int w) const
{
   impl()->setWaitRetry(w);
}

bool KTransfer::getLogProcess() const
{
   return impl()->getLogProcess();
}

void KTransfer::setLogProcess(bool l) const
{
   impl()->setLogProcess(l);
}

const char * KTransfer::docId()
{
   return KTransferImpl::DOCID;
}

const char * KTransfer::docType()
{
   return KTransferImpl::DOCTYPE;
}

KTransfer::KTransfer(KTransferImpl * impl) : KObject(impl)
{
}

KTransferImpl * KTransfer::impl() const
{
   return dynamic_cast<KTransferImpl*>(KObject::impl());
}
