/***************************************************************************
                           kmmanagerlistview.cpp - 
                         ---------------------------
    begin                : Tue Mar  6 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.6 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qtextstream.h>
#include <klocale.h>
#include <kmainwindow.h>
#include "utils.h"
#include "kmagoview.h"
#include "kmagodoc.h"
#include "kmmanager.h"
#include "kmmanagerlistview.h"

KMManagerListView::KMManagerListView(KMManager m, KMagoDoc *doc, Callback cb, 
				     QWidget *parent, const char *name)
   : KListView(parent, name), KContainerView(doc, cb, m)
{
   setAcceptDrops(true);
   setDragEnabled(true);
   setRenameable(0, true);
   setItemsMovable(false);
   setDropVisualizer(false);
   //setDropHighlighter(true);
   setSelectionMode(QListView::Single);
   setAllColumnsShowFocus(false);
   setShowSortIndicator(true);
   setMinimumSize(0, 0);

   connect(this, SIGNAL(dropped(QDropEvent*, QListViewItem*, QListViewItem*)),
	   this, SLOT(slotDropped(QDropEvent*, QListViewItem*, QListViewItem*)));
   connect(this, SIGNAL(executed(QListViewItem*)),
	   this, SLOT(slotExecuted(QListViewItem*)));
   connect(this, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)),
	   this, SLOT(slotContextMenu(KListView*, QListViewItem*, 
				      const QPoint&)));
   connect(this, SIGNAL(selectionChanged(QListViewItem*)),
	   this, SLOT(slotSelectionChanged(QListViewItem*)));
   connect(this, SIGNAL(itemRenamed(QListViewItem*, const QString&, int)),
	   this, SLOT(slotItemRenamed(QListViewItem*, const QString&, int)));

   initActions();

   _sortIdx[0] = MDI_TMN_TITLE;
   _sortIdx[1] = MDI_CNT;
   _sortIdx[2] = MDI_ACTCNT;
   _sortIdx[3] = MDI_PRIORITY;
   _sortIdx[4] = MDI_BAND;
   _sortIdx[5] = MDI_BAND;
}

KMManagerListView::~KMManagerListView()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
}

void KMManagerListView::initActions()
{
   _viewTitle = new KToggleAction(i18n("Show Title"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "mlistview_title");
   _viewCnt = new KToggleAction(i18n("Show Items Count"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "mlistview_cnt");
   _viewActCnt = new KToggleAction(i18n("Show Items Active Count"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "mlistview_actcnt");
   _viewPriority = new KToggleAction(i18n("Show Priority"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "mlistview_priority");
   _viewBand = new KToggleAction(i18n("Show Band"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "mlistview_band");
   _viewMBand = new KToggleAction(i18n("Show Medium Band"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "mlistview_mband");
}

void KMManagerListView::initView()
{
   while (columns())
      removeColumn(0);
   int i = 0;
   if (_viewTitle->isChecked())
   {
      addColumn("Title", fontMetrics().width(" XXXXXXXXXXX"));
      _columnMap[i++] = 0;
   }
   if (_viewCnt->isChecked())
   {
      addColumn("Items", fontMetrics().width(" 00"));
      _columnMap[i++] = 1;
   }
   if (_viewActCnt->isChecked())
   {
      addColumn("Actives", fontMetrics().width(" 00"));
      _columnMap[i++] = 2;
   }
   if (_viewPriority->isChecked())
   {
      addColumn("Priority", fontMetrics().width(" 000"));
      _columnMap[i++] = 3;
   }
   if (_viewBand->isChecked())
   {
      addColumn("Band", fontMetrics().width(" 0.00B"));
      _columnMap[i++] = 4;
   }
   if (_viewMBand->isChecked())
   {
      addColumn("MBand", fontMetrics().width(" 0.00B"));
      _columnMap[i++] = 5;
   }

   int j;
   for (j = 0; j < i && _columnMap[j] != _sortByCol; ++j);
   if (j < i)
      setSorting(_sortByCol, _sortDir);
   else
      setSorting(0);
}

void KMManagerListView::setSorting(int column, bool increasing)
{
   KListView::setSorting(column, increasing);
   _sortBy = _sortIdx[column];
   _sortByCol = column;
   _sortDir = increasing;
}

void KMManagerListView::setSortBy(ModIndex p, bool increasing)
{
   kdFatal(D_VIE) << name() << ": setSortBy : operation not defined" << endl;
   _sortBy = p;
   _sortDir = increasing;
}

QDragObject * KMManagerListView::dragObject() const 
{
   KTManager item = doc()->currentManager();
   if (!managerDragEnabled(item))
      return 0;
   kdDebug(D_RUN) << name() << ": new drag" << item.name() << endl;
   KTManagerListDrag *drag = 
      new KTManagerListDrag(const_cast<KMManagerListView*>(this));
   drag->setPixmap(DesktopIcon("kmultiple"));
   drag->append(item);
   /*
     if (drag->drag() && dragObj->target() != 0)
     kdDebug(D_RUN) << name() << ": drag move" << endl;
     else
     kdDebug(D_RUN) << name() << ": drag copy" << endl;
   */
   return drag;
}

bool KMManagerListView::acceptDrag(QDropEvent *event) const 
{
   //kdDebug(D_RUN) << name() << ": acceptDrag " << (source ? source->container().name() : QString::null) << " -> " << container().name() << endl;
   KMManagerListItem *item = 
      dynamic_cast<KMManagerListItem*>(itemAt(event->pos()));
   if (item == 0)
      return (KContainerView::acceptDrop(event, container())
	      && managerCanDecode(event));
   return (KContainerView::acceptDrop(event, item->manager())
	   && transferCanDecode(event));
}

KMManagerListItem * KMManagerListView::itemFind(KObject item) const 
{
   kdFatal(item.isNull(), D_VIE) << name() << ": find null object" << endl;
   KMManagerListItem *i;
   for (i = dynamic_cast<KMManagerListItem*>(firstChild());
	i != 0 && i->manager() != item;
	i = dynamic_cast<KMManagerListItem*>(i->nextSibling()));
   kdError(i == 0, D_VIE) << name() << ": manager item not found" << endl;
   return i;
}

void KMManagerListView::itemAdd(KObject item) 
{
   new KMManagerListItem(this, item.toTManager());
}

void KMManagerListView::itemRemove(KObject item) 
{
   kdFatal(item.isNull(), D_VIE) << name() << ": remove null object" << endl;
   delete itemFind(item);
}

void KMManagerListView::itemSelect(KObject item) 
{
   if (!item.isNull()) 
   {
      setSelected(itemFind(item), true);
   } 
   else 
   {
      clearSelection();
   }
}

void KMManagerListView::itemUpdate(KObject item) 
{
   if (item.isMod(sortBy()))
   {
      // changed sort key, view reset is needed
      reset();
   }
   else
   {
      KMManagerListItem *i = itemFind(item);
      if (i != 0)
      {
	 i->update();
	 i->repaint();
      }
   }
}

void KMManagerListView::itemUpdateText(KObject item) 
{
   if (item.isMod(sortBy()))
   {
      // changed sort key, view reset is needed
      reset();
   }
   else
   {
      KMManagerListItem *i = itemFind(item);
      if (i != 0)
      {
	 i->repaint();
      }
   }
}

KObject KMManagerListView::itemFirst() const
{
   KMManagerListItem *i = dynamic_cast<KMManagerListItem*>(firstChild());
   if (i == 0)
      return KObject::null();
   return i->manager();
}

KObject KMManagerListView::itemBelow(KObject item) const
{
   KMManagerListItem *i = itemFind(item);
   KMManagerListItem *b = dynamic_cast<KMManagerListItem*>(i->itemBelow());
   if (b == 0)
      return KObject::null();
   return b->manager();
}

KObject KMManagerListView::itemAbove(KObject item) const
{
   KMManagerListItem *i = itemFind(item);
   KMManagerListItem *b = dynamic_cast<KMManagerListItem*>(i->itemAbove());
   if (b == 0)
      return KObject::null();
   return b->manager();
}

void KMManagerListView::setOrientation(bool) 
{
}

int KMManagerListView::column(int i) const 
{
   return _columnMap[i];
}

void KMManagerListView::applySettings(KConfig *config) 
{
   _viewTitle->setChecked(config->readBoolEntry("MManagerListView Title", true));
   _viewCnt->setChecked(config->readBoolEntry("MManagerListView Cnt", true));
   _viewActCnt->setChecked(config->readBoolEntry("MManagerListView ActCnt", 
						 true));
   _viewPriority->setChecked(config->readBoolEntry("MManagerListView Priority", 
						   true));
   _viewBand->setChecked(config->readBoolEntry("MManagerListView Band", true));
   _viewMBand->setChecked(config->readBoolEntry("MManagerListView MBand", true));
   _sortByCol = config->readNumEntry("MManagerListView SortBy", 0);
   _sortDir = config->readBoolEntry("MManagerListView SortDir", true);
}   

void KMManagerListView::saveSettings(KConfig *config)
{
   config->writeEntry("MManagerListView Title", _viewTitle->isChecked());
   config->writeEntry("MManagerListView Cnt", _viewCnt->isChecked());
   config->writeEntry("MManagerListView ActCnt", _viewActCnt->isChecked());
   config->writeEntry("MManagerListView Priority", _viewPriority->isChecked());
   config->writeEntry("MManagerListView Band", _viewBand->isChecked());
   config->writeEntry("MManagerListView MBand", _viewMBand->isChecked());
   config->writeEntry("MManagerListView SortBy", _sortByCol);
   config->writeEntry("MManagerListView SortDir", _sortDir);
}

// slots

void KMManagerListView::slotDropped(QDropEvent * event,
				    QListViewItem *, QListViewItem *) 
{
   KMManagerListItem *item = 
      dynamic_cast<KMManagerListItem*>(itemAt(event->pos()));
   if (item == 0)
   {
      kdDebug(D_VIE) << name() << ": drop tmanager list" << endl;
      dropTManagerList(event, container());
   }
   else
   {
      kdDebug(D_VIE) << name() << ": drop transfer list" << endl;
      dropTransferList(event, doc(), item->manager());
   }
}

void KMManagerListView::slotExecuted(QListViewItem *) 
{
}

void KMManagerListView::slotContextMenu(KListView *, QListViewItem *i, 
					const QPoint &p)
{
   if (i == 0)
      return;
   kdFatal(dynamic_cast<KMManagerListItem*>(i)->manager() != doc()->currentManager()) << name() << " context menu" << endl;
   view()->managerMenu()->popup(p);
}

void KMManagerListView::slotSelectionChanged(QListViewItem * item) 
{
   //emit sigSelectionChanged(dynamic_cast<KMManagerListItem*>(item)->manager());
   itemSelectionChanged(dynamic_cast<KMManagerListItem*>(item)->manager());
}

void KMManagerListView::contentsDragMoveEvent(QDragMoveEvent *event) 
{
   KListView::contentsDragMoveEvent(event);
   //FIXME!! hack to keep working the move action
   //event->acceptAction(true);
   //kdDebug(D_VIE) << name() << ": drag action " << event->action() << endl;
}
/*
void KMManagerListView::contentsDropEvent(QDropEvent *event) 
{
//event->setAction(QDropEvent::Move);
kdDebug(D_RUN) << name() << ": drop action " << event->action() << endl;
KIconView::contentsDropEvent(event);
}
*/

void KMManagerListView::slotItemRenamed(QListViewItem * item, 
					const QString &name, int) 
{
   dynamic_cast<KMManagerListItem*>(item)->manager().setTitle(name);
   triggerUpdate();
}

void KMManagerListView::slotInitView()
{
   initView();
   reset();
}

//////////////////////////////////////////////////////////////////

KMManagerListItem::KMManagerListItem(QListView *parent, KTManager mngr)
   : QListViewItem(parent), m(mngr) 
{
   update();
}

void KMManagerListItem::update() 
{
   if (m.isNull())
   {
      kdWarning(D_VIE) << ": KMManagerListItem::update on null item" << endl;
      return;
   }
   if (m.itemActiveCount() > 0) 
   {
      if (m.getAutoDownload())
	 setPixmap(0, SmallIcon("folder_green_open"));
      else
	 setPixmap(0, SmallIcon("folder_blue_open"));
   } 
   else 
   {
      if (m.getAutoDownload())
	 setPixmap(0, SmallIcon("folder_green"));
      else
	 setPixmap(0, SmallIcon("folder_blue"));
   }
}

QString KMManagerListItem::text(int column) const
{
   if (m.isNull())
   {
      kdWarning(D_VIE) << ": KMManagerListItem::text on null item" << endl;
      return QString::null;
   }
   KMManagerListView * view = dynamic_cast<KMManagerListView*>(listView());
   switch (view->column(column))
   {
   case 0:
      return m.title();
   case 1:
      return QString::number(m.itemCount());
   case 2:
      return QString::number(m.itemActiveCount());
   case 3:
      return QString::number(m.prioritySum());
   case 4:
      return unit(m.bandwidth());
   case 5:
      return unit(m.mediumBandwidth());
   default:
      kdFatal(D_VIE) << "KMManagerListItem: column unknown " << column << endl;
   }
   return "";
}

QString KMManagerListItem::key(int column, bool) const
{
   if (m.isNull())
   {
      kdWarning(D_VIE) << ": KMManagerListItem::key on null item" << endl;
      return QString::null;
   }
   KMManagerListView * view = dynamic_cast<KMManagerListView*>(listView());
   switch (view->column(column))
   {
   case 0:
      return text(column);
   case 1:
      return QString("%1").arg(m.itemCount(), 10);
   case 2:
      return QString("%1").arg(m.itemActiveCount(), 10);
   case 3:
      return QString("%1").arg(m.prioritySum(), 10);
   default:
      kdFatal(D_VIE) << "KMManagerListItem: column unknown " << column << endl;
   }
   return "";
}

bool KMManagerListItem::acceptDrop(const QMimeSource * mime) const 
{
   return KContainerView::transferCanDecode(mime);
}
/*
void KMManagerListItem::dropped (QDropEvent * event) 
{
   // check to not drop on a dragged item
   if (event->source() != 0)
      for (QValueList<QIconDragItem>::ConstIterator i = lst.begin(); 
	   i != lst.end(); ++i) 
      {
	 QString id;
	 QTextIStream((*i).data()) >> id;
	 kdDebug(D_RUN) << "KMManagerListItem : drop item " << id << endl;
	 if (id.toInt() == m.id()) 
	 {
	    kdWarning(D_RUN) << "KMManagerListItem : drop on a dragged item " << m.name() << endl;
	    event->ignore();
	    return;
	 }
      }
   KContainerView::dropTransferList(event, dynamic_cast<KContainerView*>(iconView())->main(), manager());
}
*/

#include "kmmanagerlistview.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
