/***************************************************************************
                          kmmanager.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.8 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmmanagerimpl.h"
#include "ktmanager.h"
#include "kmmanager.h"


KMManager KMManager::managerLoad(const QString &fileName, bool createMode,
				 KNotifyChange *cb) 
{
   KMManagerImpl *m = new KMManagerImpl();
   if (!m->init(fileName, createMode, cb))
   {
      // error creating manager
      delete m;
      return KMManager::null();
   }
   else
      return KMManager(m);
}

KTManager KMManager::itemNew(const QString &title) const
{
   return KTManager(impl()->itemNew(title));
}

int KMManager::bandwidth() const 
{
   return impl()->bandwidth();
}

int KMManager::mediumBandwidth() const 
{
   return impl()->mediumBandwidth();
}

QString KMManager::docId() 
{ 
   return KMManagerImpl::DOCID; 
}

QString KMManager::docType() 
{
   return KMManagerImpl::DOCTYPE;
}

void KMManager::startPendingTransfer()
{
   impl()->startPendingTransfer();
}

bool KMManager::downloadLock() const 
{
   return impl()->downloadLock();
}
 
void KMManager::setDownloadLock(bool v) const
{
   impl()->setDownloadLock(v);
}

bool KMManager::isIdle() const 
{
   return impl()->isIdle();
}
 
void KMManager::setIdle(bool l)
{
   impl()->setIdle(l);
}

int KMManager::getMaxConnection() const 
{
   return impl()->getMaxConnection();
}

void KMManager::setMaxConnection(int c) const
{
   impl()->setMaxConnection(c);
}

int KMManager::getMaxBandwidth() const 
{
   return impl()->getMaxBandwidth();
}

void KMManager::setMaxBandwidth(int b) const
{
   impl()->setMaxBandwidth(b);
}

KMManager::KMManager(KMManagerImpl *impl) : KRootContainer(impl) 
{
}

KMManagerImpl * KMManager::impl() const 
{
   return dynamic_cast<KMManagerImpl*>(KRootContainer::impl());
}
