/***************************************************************************
                          kdlgtransferwget1.cpp  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.11 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef ENABLE_WGET

#include <klocale.h>
#include <qfileinfo.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgrid.h>
#include "kdlgtransferwget1.h"

KDlgTransferWget1::KDlgTransferWget1(KTransferWget tr, QWidget *parent, 
				     const char *name) 
   : QWidget(parent,name)
{
   t = tr;
   initDialog();
   slotSetGlobal(t.useGlobal());
}

KDlgTransferWget1::~KDlgTransferWget1()
{
}

void KDlgTransferWget1::init()
{
   cbtCache->setChecked(t.getHTTPCache());
   cbtPasv->setChecked(t.getPassiveFtp());
   cbtProxy->setChecked(t.getProxy());
   lneNoProxy->setText(t.getNoProxyList().join(","));
   lnePFA->setText(t.getProxyFTP());
   lnePFP->setText(QString().setNum(t.getProxyPortFTP()));
   lnePHA->setText(t.getProxyHTTP());
   lnePHP->setText(QString().setNum(t.getProxyPortHTTP()));
   lneReadTO->setText(QString().setNum(t.getReadTimeout()));
   lneCmdPath->setText(t.getCmdPath());
   cmbSpeed->setCurrentItem(t.getSpeed());
   cbtIgnLen->setChecked(t.getIgnoreLength());
}

void  KDlgTransferWget1::initDialog()
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this, "GB1");
   l->addWidget(gbox);

   QHBox *box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Command Path"), box, "lneCmdPath");
   lneCmdPath = new QLineEdit(box, "LneCmdPath");
   QToolTip::add(lneCmdPath,i18n("Path of wget executable"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneCmdPath, 0);

   box = new QHBox(gbox);  
   lbl = new QLabel(i18n("Read Timeout"), box);
   lneReadTO = new QLineEdit(box, "lneReadTO");
   lneReadTO->setFixedWidth(lneReadTO->fontMetrics().width("XXXXXX"));
   QToolTip::add(lneReadTO,i18n("Read Timeout in seconds"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneReadTO, 0);

   cbtPasv = new QCheckBox(i18n("Enable FTP passive mode"), gbox, "cbtPasv");

   cbtCache = new QCheckBox(i18n("Allow HTTP server-cached data"), gbox, 
			    "cbtCache");
   cbtIgnLen = new QCheckBox(i18n("Ignore Content-Length header"), gbox, 
			     "cbtIgnLen");
  
   box = new QHBox(gbox);  
   lbl = new QLabel(i18n("Transfer Speed"), box);
   cmbSpeed = new KComboBox(box, "cmbSpeed");
   QToolTip::add(cmbSpeed,i18n("Transfer speed"));
   cmbSpeed->insertItem("Default");
   cmbSpeed->insertItem("Binary");
   cmbSpeed->insertItem("Mega");
   cmbSpeed->insertItem("Micro");
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(cmbSpeed, 0);

   gbox = new QGroupBox(1, Horizontal, i18n("Proxy"), this, "GB2");
   l->addWidget(gbox);

   cbtProxy = new QCheckBox(i18n("Enable Proxy"), gbox, "cbtProxy");
   connect(cbtProxy, SIGNAL(toggled(bool)), this, SLOT(slotSetProxy(bool)));

   QWidget *wbox = new QWidget(gbox);
   QGridLayout * lgrid = new QGridLayout(wbox, 2, 4, 4);

   lbl = new QLabel(i18n("HTTP Proxy:"), wbox);
   lgrid->addWidget(lbl, 0, 0);
   lnePHA = new QLineEdit(wbox, "lnePHA");
   QToolTip::add(lnePHA, i18n("HTTP proxy host name"));
   lgrid->addWidget(lnePHA, 0, 1);
   lbl = new QLabel(i18n("Port:"), wbox);
   lgrid->addWidget(lbl, 0, 2);
   lnePHP = new QLineEdit(wbox, "lnePHP");
   lnePHP->setFixedWidth(lnePHP->fontMetrics().width("XXXXX"));
   lgrid->addWidget(lnePHP, 0, 3);

   lbl = new QLabel(i18n("FTP Proxy:"), wbox);
   lgrid->addWidget(lbl, 1, 0);
   lnePFA = new QLineEdit(wbox, "lnePFA");
   QToolTip::add(lnePFA, i18n("Ftp proxy host name"));
   lgrid->addWidget(lnePFA, 1, 1);
   lbl = new QLabel(i18n("Port:"), wbox);
   lgrid->addWidget(lbl, 1, 2);
   lnePFP = new QLineEdit(wbox, "lnePFP");
   lnePFP->setFixedWidth(lnePFP->fontMetrics().width("XXXXX"));
   lgrid->addWidget(lnePFP, 1, 3);

   lgrid->setColStretch(0, 1);
   lgrid->setColStretch(1, 10);
   lgrid->setColStretch(2, 1);
   lgrid->setColStretch(3, 0);

   new QLabel(i18n("No Proxy for:"), gbox);
   lneNoProxy = new QLineEdit(gbox, "lneNoProxy");
   QToolTip::add(lneNoProxy, i18n("List of comma separated host names, glob expressions are accepted for grouping, like *.xxx.yyy, or xxx.*"));

   adjustSize();
   setMinimumSize(size());
}

void KDlgTransferWget1::accept()
{
   t.setNoProxyList(QStringList::split(",", lneNoProxy->text()));
   t.setProxyFTP(lnePFA->text());
   t.setProxyPortFTP(QString(lnePFP->text()).toInt());
   t.setProxyHTTP(lnePHA->text());
   t.setProxyPortHTTP(QString(lnePHP->text()).toInt());
   t.setReadTimeout(QString(lneReadTO->text()).toInt());
   t.setProxy(cbtProxy->isChecked());
   t.setHTTPCache(cbtCache->isChecked());
   t.setPassiveFtp(cbtPasv->isChecked());
   t.setSpeed(static_cast<TransferSpeed>(cmbSpeed->currentItem()));
   t.setCmdPath(lneCmdPath->text());
   t.setIgnoreLength(cbtIgnLen->isChecked());
}

void KDlgTransferWget1::reject()
{
}

bool KDlgTransferWget1::isAcceptable()
{
   bool check;
   check = QString(lnePFP->text()).toInt();
   if (!check)
      return false;
   check = QString(lnePHP->text()).toInt();
   if (!check)
      return false;
   check = QString(lneReadTO->text()).toInt();
   if (!check)
      return false;
   QFileInfo f(lneCmdPath->text());
   if (!f.isExecutable())
      return false;
   return true;
}

void KDlgTransferWget1::slotSetProxy(bool on) 
{
   lneNoProxy->setEnabled(on);
   lnePFA->setEnabled(on);
   lnePFP->setEnabled(on);
   lnePHA->setEnabled(on);
   lnePHP->setEnabled(on);
}

void KDlgTransferWget1::slotSetGlobal(bool on) 
{
   cbtCache->setEnabled(!on);
   cbtIgnLen->setEnabled(!on);
   cbtPasv->setEnabled(!on);
   cbtProxy->setEnabled(!on);
   lneReadTO->setEnabled(!on);
   lneCmdPath->setEnabled(!on);
   cmbSpeed->setEnabled(!on);
   slotSetProxy(!on && t.getProxy());
   init();
}

#include "kdlgtransferwget1.moc"

#endif
