/***************************************************************************
                          kdlgmanager.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.8 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGMANAGER_H
#define KDLGMANAGER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <klocale.h>
#include <kdialogbase.h>
#include "ktmanager.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif


class KDlgManager1;
class KDlgManagerSet;
class KDlgTransfer1;
#ifdef ENABLE_WGET
class KDlgTransferWget1;
#endif
#ifdef ENABLE_KIO
class KDlgTransferKio1;
#endif

/**
 * @short Dialog class for @ref KTManager configuration
 * 
 * @author Sergio Moretti
 * 
 * @version $Id: kdlgmanager.h,v 1.8 2001/03/05 20:59:22 sergio Exp $
 * 
 * This is a tabbed dialog created with pages for @ref KTManager
 * configuration, @ref KDlgManager1, plus all the pages of 
 * transfers classes contained in manager, @ref @KDlgTransfer1, 
 * @ref KDlgTransferWget1, ...
 */

class KDlgManager : public KDialogBase 
{
   Q_OBJECT

public:
   KDlgManager(KTManager mngr, QWidget *parent, const char *name=0);
   ~KDlgManager();

protected slots: // Protected slots
   void slotOk();
   void slotCancel();

protected: // Protected methods
   /** init dialog state */
   void init();

private:
   KTManager m;
   KDlgManagerSet *_ps;
   KDlgManager1 *_p1;
#ifdef ENABLE_WGET
   KDlgTransfer1 *_p2;
   KDlgTransferWget1 * _p3;
#endif
#ifdef ENABLE_KIO
   KDlgTransfer1 * _p4;
   KDlgTransferKio1 *_p5;
#endif
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
