#ifndef __DEVICE_PWR__
#define __DEVICE_PWR__

#include <qpainter.h>
#include "xdevice.h"

// static output value device
class PowerDevice : public XDevice
{
public:
	PowerDevice(int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: XDevice(DeviceType::fPWR, x, y, size, del, undef, clock)
	{
		m_iInputValue = 0;
	}

	virtual ~PowerDevice()
	{
	}

	virtual void init()
	{
		m_bChangedOutput = true;
		m_bLastChangedOutput = false;
		deviceOutputInverted = false;
		deviceMaxInput = 0;
		deviceMaxOutput = 1;

		XDevice::init();
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual void setEquation()
	{
		Device::setEquation(Operator::NONE);
	}

	virtual bool hasClock()
	{
		return false;
	}

	virtual bool sizeChangeable()
	{
		return false;
	}

	virtual bool isEditable()
	{
		return false;
	}

	virtual bool hasStaticInput() const
	{
		return true;
	}

	// set static output-value
	virtual void toggleStaticInput()
	{
		m_bChangedOutput = true;
		if (m_iInputValue) m_iInputValue = 0;
		else m_iInputValue = 1;
	}

	// set static input-value
	virtual void setStaticInput(int val)
	{
		if (val != m_iInputValue)
			m_bChangedOutput = true;
		m_iInputValue = val;
	}

	virtual void setImage()
	{	QPixmap *pic = getImage();
		QPixmap *poImg = 0;
		QPoint pt(0, 0);
		QPainter p;
		QPoint pp(15, 35);

		if (m_iInputValue)
			poImg = pxPOS;
		else
			poImg = pxNEG;
		pic->resize(poImg->width(), poImg->height());

		p.begin(pic);
		p.drawPixmap(pt, *poImg);
		setVOffset(5);
		drawConnectionLines(&p);
		XObject::setImage();
		p.end();

		if (m_oTextDev) m_oTextDev->setImage();
	}

	virtual void printImage(QPainter *p, const QRect &r)
	{
		int a = r.x() + 2;
		int b = r.y() + (r.height() / 2) + 2;
		int c = r.x() + r.width() - XObject::IOREG - 2;
		int d = r.x() + ((r.width() - XObject::IOREG) / 2);
		p->drawArc(r.x(), r.y() + 3, r.width() - XObject::IOREG, r.height() - 3, 0, 5760);
		p->drawLine(a, b, c, b);
		if (m_iInputValue)
			p->drawLine(d, r.y() + 5, d, r.y() + r.height() - 2);
		// extended connection line
		p->drawLine(r.x() + r.width() - XObject::IOREG, b, r.x() + r.width(), b);
	}

	// set image in dependance of output value
	virtual bool setColor()
	{
		if (!outputChanged())
			return false;

		QPixmap *poImg = 0;
		if (m_iInputValue)
			poImg = pxPOS;
		else
			poImg = pxNEG;

		QPainter p;
		QPixmap *pic = getImage();
		p.begin(pic);
		QPoint pp(0,0);
		p.drawPixmap(pp, *poImg);
		drawConnectionLines(&p);
		p.end();
		return true;
	}

	virtual bool drawGraph()
	{
		return false;
	}

	virtual int output(int = 0)
	{
		return m_iInputValue;
	}

	virtual int outputChanged()
	{
		return m_bChangedOutput;
	}

	virtual void forceOutputChange()
	{
		m_bChangedOutput = true;
	}

	virtual void Calculate(int)
	{
	}

	virtual void Propagate(int)
	{
		if (m_bChangedOutput) {
			if (!m_bLastChangedOutput) {
				m_bLastChangedOutput = true;
			} else {
				m_bLastChangedOutput = false;
				m_bChangedOutput = false;
			}
		}
	}

private:
	int m_iInputValue;
	bool m_bChangedOutput;
	bool m_bLastChangedOutput;
};

#endif
