/*************************************************/
/* this interface class is used for customizing  */
/* devices                                       */
/*                                               */
/* all methods that are not part of device.cpp   */
/* can be ivirtually added here, to make them    */
/* visible in xdevice                            */
/*                                               */
/* Andreas Rostin                                */
/* 06.10.01                                      */
/*************************************************/
#ifndef __DEVICE_INTERFACE__
#define __DEVICE_INTERFACE__
#include "xdevice.h"
#include "device.h"

// ------------------------------------------------------------
// all methods defined here should be virtual
// ------------------------------------------------------------
class DeviceInterface : public Device
{
public:
	DeviceInterface(int function, int delay = -1, int undefined = -1, int clock = -1)
		:Device(function, delay, undefined, clock)
	{
	}

	virtual ~DeviceInterface()
	{
	}

	// -----------------------------------------------------
	// retrieve device pointer: cast needed!
	// -----------------------------------------------------
	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual bool sizeChangeable()
	{
		return false;
	}

	// -----------------------------------------------------
	// Oscillator device
	// -----------------------------------------------------
	virtual int oszOn() { return 0; }
	virtual void setOszOn(int) {}
	virtual int oszOff() { return 0; }
	virtual void setOszOff(int) {}
	virtual int getCurrOszStep() { return 0; }
	virtual void setCurrOszStep(int) {}

	// -----------------------------------------------------
	// RAM device
	// -----------------------------------------------------
	virtual int RAMSize() { return 0; }			// size of ram device
	virtual void setRAMSize(int) {}
	virtual void setRAMStorage(char *) {}			// replace ram content copletely
	virtual char *getRAMStorageCopy() { return NULL; }	// returns a copy of the ram

	// -----------------------------------------------------
	// Bus device
	// -----------------------------------------------------
	virtual bool isMux() { return false; }
	virtual void setMux(bool) {}

	// -----------------------------------------------------
	// Switch/Power device
	// -----------------------------------------------------
	virtual bool hasStaticInput() const { return false; }
	virtual bool isToggle() const { return false; }
	virtual void setToggle(bool) {}
	virtual void toggleStaticInput() {}
	virtual void setStaticInput(int) {}

	// -----------------------------------------------------
	// IO device, Switch device
	// -----------------------------------------------------
	virtual bool isEditable() { return true; }
	virtual bool isInteractive() { return false; }
	virtual void setHasBooleanOutput(int, bool) {}

	// common
	virtual void setUndef(int val) { Device::setUndef(val); };
protected:

private:

};

#endif
