#ifndef __DEVICE_IO__
#define __DEVICE_IO__

#include <set>
using namespace std;

#include <qpainter.h>
#include "xdevice.h"

// interface devices for circuit
class IODevice : public XDevice
{
public:
	IODevice(int type, int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: XDevice(type, x, y, size, del, undef, clock)
	{
	}

	virtual ~IODevice()
	{
	}

	virtual void init()
	{
		deviceOutputInverted = false;
		m_bHasBooleanOutput = true;
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual void setEquation()
	{
		Device::setEquation(Operator::INTERFACE);
	}

	virtual bool hasClock()
	{
		return false;
	}

	virtual bool sizeChangeable()
	{
		return false;
	}

	virtual bool isEditable()
	{
		return false;
	}

	virtual bool hasBooleanOutput(int)
	{
		return m_bHasBooleanOutput;
	}

	virtual void setHasBooleanOutput(int, bool bHasBooleanInput)
	{
		m_bHasBooleanOutput = bHasBooleanInput;
	}

	virtual void printImage(QPainter *p, const QRect &r)
	{
		p->setFont(STATfont);
		p->drawText(r.x() + 6, r.y() + 9, getName());
	}

private:
	int m_bHasBooleanOutput;
};

// interface devices for circuit
class InputDevice : public IODevice
{
public:
	InputDevice(int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: IODevice(DeviceType::fIN, x, y, size, del, undef, clock)
	{
		if (!Device::IMPORT_IGNORE_GLOBAL) setImage();
	}

	virtual ~InputDevice()
	{
	}

	virtual void init()
	{
		m_bChangedOutput = true;
		m_bLastChangedOutput = false;
		deviceMaxInput = 0;

		IODevice::init();
		XDevice::init();
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	// set static input-value
	virtual void setStaticInput(int val)
	{
		if (val != m_iInputValue)
			m_bChangedOutput = true;
		m_iInputValue = val;
	}

	virtual void setImage()
	{	QPixmap *pic = getImage();
		QPoint pt(0, 0);
		QPainter p;
		QPoint pp(15, 35);

		pic->resize(pxIN->width(), pxIN->height());

		p.begin(pic);
		p.drawPixmap(pt, *pxIN);
		// draw symbol
		p.setFont(STATfont);
		p.drawText(10, 9, getName());
		setVOffset(5);

		drawConnectionLines(&p);
		XObject::setImage();

		p.end();

		if (m_oTextDev) m_oTextDev->setImage();
	}

	virtual int output(int = 0)
	{
		return m_iInputValue;
	}

	virtual int outputChanged()
	{
		return m_bChangedOutput;
	}

	virtual void forceOutputChange()
	{
		m_bChangedOutput = true;
	}

	virtual void Calculate(int)
	{
	}

	virtual void Propagate(int)
	{
		if (m_bChangedOutput) {
			if (!m_bLastChangedOutput) {
				m_bLastChangedOutput = true;
			} else {
				m_bLastChangedOutput = false;
				m_bChangedOutput = false;
			}
		}
	}

private:
        int m_iInputValue;
        bool m_bChangedOutput;
        bool m_bLastChangedOutput;
};

class OutputDevice : public IODevice
{
public:
	OutputDevice(int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: IODevice(DeviceType::fOUT, x, y, size, del, undef, clock)
	{
	}

	virtual ~OutputDevice()
	{
	}

	virtual void init()
	{
		deviceMaxInput = 1;
		IODevice::init();
		XDevice::init();
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual bool hasBooleanOutput(int)
	{	KlogicList<Device> *li = connection_list.First();

		while(li) {
			if (!(li->Get()->hasBooleanOutput(li->getID2())))
				return false;
			li = li->Next();
		}
		return true;
	}

	virtual void setImage()
	{	QPixmap *pic = getImage();
		QPoint pt(0, 0);
		QPainter p;
		QPoint pp(15, 35);

		pic->resize(pxOUT->width(), pxOUT->height());

		p.begin(pic);
		p.drawPixmap(pt, *pxOUT);
		// draw symbol
		p.setFont(STATfont);
		p.drawText(10, 9, getName());
		setVOffset(5);

		drawConnectionLines(&p);
		XObject::setImage();

		p.end();

		if (m_oTextDev) m_oTextDev->setImage();
	}
};

#endif
