#include "deviceFactory.h"
#include "deviceTypes.h"
#include "circuit.h"
#include "deviceMuxDemux.h"
#include "deviceOsc.h"
#include "deviceRAM.h"
#include "deviceJKFF.h"
#include "deviceIO.h"
#include "deviceSwitch.h"
#include "devicePwr.h"
#include "deviceText.h"
#include "mainw.h"
#include "devLib.h"

DeviceFactory * DeviceFactory::m_pInstance = 0;

// create a new device
// if size is given, it's an import call
XDevice *DeviceFactory::createDevice(XDevice *parent, int function, int x, int y, int size)
{
	XDevice *dev = 0;

	if (function >= DeviceType::fFIRST_LIBDEV && function <= DeviceType::fLAST_LIBDEV) {
		// instanciate lib device
		if (MainWidget::activeLib && parent->devIsCircuit())
			dev = MainWidget::activeLib->createInstance(parent->devIsCircuit(), function, x, y);
	} else {
		// instanciate new device
		switch(function) {
			case DeviceType::fNET:
				// new net device
				dev = new Circuit(x, y, size);
				break;
			case DeviceType::fRAM:
				dev = new RAMDevice(x, y, size);
				break;
			case DeviceType::fOSC:
				dev = new OscillatorDevice(x, y, size);
				break;
			case DeviceType::fBUS:
				dev = new BusDevice(x, y, size);
				break;
			case DeviceType::fJK:
				dev = new JKFFDevice(x, y, size);
				break;
			case DeviceType::fIN:
				dev = new InputDevice(x, y, size);
				break;
			case DeviceType::fOUT:
				dev = new OutputDevice(x, y, size);
				break;
			case DeviceType::fPWR:
				dev = new PowerDevice(x, y, size);
				break;
			case DeviceType::fSWI:
				dev = new SwitchDevice(x, y, size);
				break;
			case DeviceType::fTXT:
				dev = new TextDevice(x, y, size);
				break;
			default:
				dev = new XDevice(function, x, y, size);
				break;
		}
		dev->init();
	}

	if (dev && parent) {
		dev->setParent(parent);
		bool bImport = (size != -1);
		if (!parent->setChild(dev, bImport)) {
			delete dev;
			dev = 0;
		}
	}

	return dev;
}

