#include <stdio.h>
#include <tool.h>
#include <qstring.h>

unsigned int Tool::powTab[] = {1,2,4,8,16,32,64,128,256,512,
                              1024,2048,4096,8192,16384,32768,65536,131072,262144,524288,
                              1048576,2097152,4194304,8388608,16777216,
                              33554432,67108864,134217728,268435456, 536870912,1073741824};

unsigned int Tool::pow2(int value)
{
	if (value > MAXPOW) {
		fprintf(stderr, "tool::pow2(%d) overflow\n", value);
		return 0;
	}
	if (value < 0) {
		fprintf(stderr, "tool::pow2(%d) negative exponent\n", value);
		return 0;
	}
	return powTab[value];
}
 
// static
int Tool::pow2complement(int base, int clearbit)
{
	int value = pow2(base);
	value += value - 1;             //all bits on
	value -= pow2(clearbit);        //clear bit
	return value;
}

// static
QString Tool::bitString(char byte, int len)
{	char ret[len + 1];

	for(int i = 0; i < len; i++) {
		if (byte & Tool::pow2(i)) {
			ret[len - i - 1] = '1';
		} else {
			ret[len - i - 1] = '0';
		}
	}
	ret[len] = 0;
	return QString(ret);
}

