//****************************************************************
//** digital simulation 
//** 
//** Andreas Rostin
//** 12.10.1997
//****************************************************************
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klogic.h>
#include <version.h>
#include <mainw.h>

// unique-id counter
int uniqueID::id = 0;

// global information
QString CurrentCircuit::filename = "";
QString CurrentCircuit::version = "";
QString CurrentCircuit::creation = "";
QString CurrentCircuit::author = "";
QString CurrentCircuit::title = "";
QString CurrentCircuit::comment = "";

static KCmdLineOptions options[] =
{
	{ "+[File]", i18n("file to open"), 0 },
	{ 0, 0, 0 }
};

int main( int argc, char **argv )
{	KApplication *a;
	MainWidget *w;

	uniqueID::reset();

	const char *description = i18n("digital circuit simulator");
	KAboutData aboutData(myAppName, myAppName,
		VERSION, description, KAboutData::License_GPL,
		"(c) 2002 Andreas Rostin", 0, 0, "andreas@a-rostin.de");

	aboutData.addAuthor("Andreas Rostin",0, "andreas@a-rostin.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

	a = new KApplication();				// takes KCmdLineArgs and KAboutData

	// main-widget
	if (a->isRestored()) {
		RESTORE(MainWidget(a));
	} else {
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count() == 1)
			w = new MainWidget(a, args->arg(0));
		else
			w = new MainWidget(a);
		args->clear();
		a->setMainWidget(w);
    		w->show();
	}

    	return a->exec();

	delete w;
}

