/***************************************************************************
                                  sound.h
                             -------------------
    begin                : Mon march 10 2001
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SOUND_H
#define SOUND_H

#include <qstring.h>

/**
 * Plays sounds.
 * This class is used to play sounds.  Events such as a message
 * received or a buddy signing on are cause for sounds to be played.
 *@author Benjamin Meyer
 */

class Sound  {

public: 

  /**
   * Contructor.
   */
  Sound();

  /**
   * Destructor.
   */
  ~Sound();

  /**
   * Set the command to play sounds with.
   * @param command the name of the program to play sounds
   * This sets the program used to play the sound files.
   */
  void setSound(QString command);

  /**
   * Use system speaker to beep.
   * This uses the internal speaker to make a beep.
   */
  void beep();

  /**
   * Play a sound file.
   * @param file the full path to the file to play
   * Plays a sound file using the specified command.
   */

  void playFile(QString file);

  /**
   * Mutes sound.
   * @param bool specify whether to mute or not
   * Suppresses sound output.  If mute is true sound will not be
   * played.
   */
  void muteSound(bool=false);

  /**
   * The command used to play sounds.
   */
  QString playCommand;

private:
  /**
   * Don't play sounds if true.
   */
  bool mute;

};
#endif

// sound.h

