/***************************************************************************
                               TextOptionsImp.h
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef TEXTOPTIONSIMP_H
#define TEXTOPTIONSIMP_H

#include <textoptions.h>
#include <setup.h>

/**
  *@author Benjamin Meyer
  */

class TextOptionsImp : public TextOptions  {

Q_OBJECT
	
signals:
  void saveSettings();

public:
  TextOptionsImp(QWidget *parent=0, const char *name=0);
  ~TextOptionsImp();

public slots:
  void updateData();
  void getData();

private slots:
  void changeUserTextColor();
  void changeBuddyTextColor();
  void changeUserNameColor();
  void changeBuddyNameColor();
  void changeBuddyBGColor();
  void changeUserBGColor();
  void setDefaultBuddyColors();
  void setDefaultUserColors();
  void changeUserFont();
  void changeBuddyFont();
  void setDefaultUserFont();
  void setDefaultBuddyFont();
  void changebuddylistOnlineFont();
  void changebuddylistOfflineFont();
  void changebuddylistSignOnFont();
  void setDefaultbuddylistOnlineFont();
  void setDefaultbuddylistOfflineFont();
  void setDefaultbuddylistSignOnFont();

private:
	void updateFontSetting(QFont &f, QLabel *l);
	void updateLabel(QLabel *l, const QFont &f);
  settings_t *i_aimSettings;
  void getNewColor(QColor &c, QPushButton *l);
};

#endif

// TextOptionsImp.h







