/***************************************************************************
                               TextOptionsImp.cpp
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "textoptionsimp.h"
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qspinbox.h>
#include <qfont.h>
#include <qlabel.h>
#include <kcolordialog.h>
#include <kfontdialog.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
TextOptionsImp::TextOptionsImp(QWidget *parent, const char *name) : TextOptions ( parent,name,false ){
	i_aimSettings = setup::settings();
  
  connect(chat_color_bname, SIGNAL(clicked()), this, SLOT(changeBuddyNameColor())); 
  connect(chat_color_btext, SIGNAL(clicked()), this, SLOT(changeBuddyTextColor())); 
  connect(chat_color_yname, SIGNAL(clicked()), this, SLOT(changeUserNameColor())); 
  connect(chat_color_ytext, SIGNAL(clicked()), this, SLOT(changeUserTextColor())); 
  connect(chat_color_ybcolor, SIGNAL(clicked()), this, SLOT(changeUserBGColor())); 
  connect(chat_color_bbcolor, SIGNAL(clicked()), this, SLOT(changeBuddyBGColor())); 
  connect(BuddyColorDefault, SIGNAL(clicked()), this, SLOT(setDefaultBuddyColors()));
  connect(MyColorDefault, SIGNAL(clicked()), this, SLOT(setDefaultUserColors()));
  connect(yourFont_change, SIGNAL(clicked()), this, SLOT(changeUserFont()));
  connect(buddyFont_change, SIGNAL(clicked()), this, SLOT(changeBuddyFont()));
  connect(yourFont_default, SIGNAL(clicked()), this, SLOT(setDefaultUserFont()));
  connect(buddyFont_default, SIGNAL(clicked()), this, SLOT(setDefaultBuddyFont()));
  connect(buddylistOnlineFont_change, SIGNAL(clicked()), this, SLOT(changebuddylistOnlineFont()));
  connect(buddylistOnlineFont_default, SIGNAL(clicked()), this, SLOT(setDefaultbuddylistOnlineFont()));
  connect(buddylistOfflineFont_change, SIGNAL(clicked()), this, SLOT(changebuddylistOfflineFont()));
  connect(buddylistOfflineFont_default, SIGNAL(clicked()), this, SLOT(setDefaultbuddylistOfflineFont()));
  connect(buddylistSignOnFont_change, SIGNAL(clicked()), this, SLOT(changebuddylistSignOnFont()));
  connect(buddylistSignOnFont_default, SIGNAL(clicked()), this, SLOT(setDefaultbuddylistSignOnFont()));
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
TextOptionsImp::~TextOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void TextOptionsImp::updateData(){
	i_aimSettings = setup::settings();


  QPixmap color;
  color.resize(40,20);
  
  color.fill(i_aimSettings->chatColorSettings->chat_yourText_color);
  chat_color_ytext->setPixmap(color);  
  color.fill(i_aimSettings->chatColorSettings->chat_yourName_color);
  chat_color_yname->setPixmap(color);
  color.fill(i_aimSettings->chatColorSettings->chat_yourbg_color);
  chat_color_ybcolor->setPixmap(color);

  color.fill(i_aimSettings->chatColorSettings->chat_buddyText_color);
  chat_color_btext->setPixmap(color);  
  color.fill(i_aimSettings->chatColorSettings->chat_buddyName_color);
  chat_color_bname->setPixmap(color);
  color.fill(i_aimSettings->chatColorSettings->chat_buddybg_color);
  chat_color_bbcolor->setPixmap(color);

	updateLabel(TextLabel_yourFont, i_aimSettings->chatFontSettings->chat_yourFont);

	updateLabel(TextLabel_buddyFont, i_aimSettings->chatFontSettings->chat_buddyFont);

	updateLabel(TextLabel_buddylistOnlineFont, i_aimSettings->buddylistFontSettings->buddylist_OnlineFont);

	updateLabel(TextLabel_buddylistOfflineFont, i_aimSettings->buddylistFontSettings->buddylist_OfflineFont);

	updateLabel(TextLabel_buddylistSignOnFont, i_aimSettings->buddylistFontSettings->buddylist_SignOnFont);
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void TextOptionsImp::getData(){
  emit (saveSettings());
}

/******************************************************************************
 * Helper Function
 ******************************************************************************/
 void TextOptionsImp::getNewColor(QColor &c, QPushButton *l){
  KColorDialog::getColor ( c, this );
	QPixmap color;
  color.resize(40,20);
  color.fill(c);
  l->setPixmap(color);
}

/******************************************************************************
 * Bring up the dialog to change the user text color.
 ******************************************************************************/
void TextOptionsImp::changeUserTextColor(){
  getNewColor(i_aimSettings->chatColorSettings->chat_yourText_color, chat_color_ytext);
}

/******************************************************************************
 * Bring up the dialog to change the buddy text color.
 ******************************************************************************/
void TextOptionsImp::changeBuddyTextColor(){
  getNewColor(i_aimSettings->chatColorSettings->chat_buddyText_color, chat_color_btext);
}

/******************************************************************************
 * Bring up the dialog to change the user name color.
 ******************************************************************************/
void TextOptionsImp::changeUserNameColor(){
  getNewColor(i_aimSettings->chatColorSettings->chat_yourName_color, chat_color_yname);
}

/******************************************************************************
 * Bring up the dialog to change the buddy name color.
 ******************************************************************************/
void TextOptionsImp::changeBuddyNameColor(){
  getNewColor(i_aimSettings->chatColorSettings->chat_buddyName_color, chat_color_bname);
}  

/******************************************************************************
 * Bring up the dialog to change the buddy background color.
 ******************************************************************************/
void TextOptionsImp::changeBuddyBGColor(){
  getNewColor(i_aimSettings->chatColorSettings->chat_buddybg_color, chat_color_bbcolor);
}

/******************************************************************************
 * Bring up the dialog to change the users background color.
 ******************************************************************************/
void TextOptionsImp::changeUserBGColor(){
  getNewColor(i_aimSettings->chatColorSettings->chat_yourbg_color, chat_color_ybcolor);
}

/******************************************************************************
 * Helper function
 ******************************************************************************/
void TextOptionsImp::updateLabel(QLabel *l, const QFont &f){
	l->setFont( f );
	l->setText( f.family() + " " + QString::number(f.pointSize()) + "pt");
}

/******************************************************************************
 * Font Dialog function
 ******************************************************************************/
void TextOptionsImp::updateFontSetting(QFont &f, QLabel *l){
  if( KFontDialog::getFont(f, false, this) )
		updateLabel(l, f);
}

/******************************************************************************
 * Bring up the dialog to change the users font.
 ******************************************************************************/
void TextOptionsImp::changeUserFont(){
	updateFontSetting(i_aimSettings->chatFontSettings->chat_yourFont, TextLabel_yourFont);
}


/******************************************************************************
 * Bring up the dialog to change the buddy font.
 ******************************************************************************/
void TextOptionsImp::changeBuddyFont(){
	updateFontSetting(i_aimSettings->chatFontSettings->chat_buddyFont, TextLabel_buddyFont);
}


/******************************************************************************
 * Bring up the dialog to change the buddylist Online font.
 ******************************************************************************/
void TextOptionsImp::changebuddylistOnlineFont(){
	updateFontSetting(i_aimSettings->buddylistFontSettings->buddylist_OnlineFont, 
             TextLabel_buddylistOnlineFont);
}

/******************************************************************************
 * Bring up the dialog to change the buddylist Offline font.
 ******************************************************************************/
void TextOptionsImp::changebuddylistOfflineFont(){
	updateFontSetting(i_aimSettings->buddylistFontSettings->buddylist_OfflineFont, 
  TextLabel_buddylistOfflineFont);
}

/******************************************************************************
 * Bring up the dialog to change the buddylist Signon font.
 ******************************************************************************/
void TextOptionsImp::changebuddylistSignOnFont(){
	updateFontSetting(i_aimSettings->buddylistFontSettings->buddylist_SignOnFont, 
  TextLabel_buddylistSignOnFont);
}

/******************************************************************************
 * set the default user Font
 ******************************************************************************/
void TextOptionsImp::setDefaultUserFont(){
  QFont tempFont;
	tempFont = qApp->font();
        tempFont.setPointSize(12);
        i_aimSettings->chatFontSettings->chat_yourFont = tempFont;
	updateLabel(TextLabel_yourFont, tempFont);
}

/******************************************************************************
 * set the default buddy Font
 ******************************************************************************/
void TextOptionsImp::setDefaultBuddyFont(){
  QFont tempFont;
	tempFont = qApp->font();
        tempFont.setPointSize(12);
	i_aimSettings->chatFontSettings->chat_buddyFont = tempFont;
	updateLabel(TextLabel_buddyFont, tempFont);
}

/******************************************************************************
 * set the default buddy list Online Font
 ******************************************************************************/
void TextOptionsImp::setDefaultbuddylistOnlineFont(){
  QFont tempFont;
	tempFont = i_aimSettings->buddylistFontSettings->buddylist_OnlineFont = qApp->font();
	updateLabel(TextLabel_buddylistOnlineFont, tempFont);
}

/******************************************************************************
 * set the default buddy list Offline Font
 ******************************************************************************/
void TextOptionsImp::setDefaultbuddylistOfflineFont(){
  QFont tempFont;
	tempFont = qApp->font();
	tempFont.setItalic( TRUE );
	i_aimSettings->buddylistFontSettings->buddylist_OfflineFont = tempFont;
	updateLabel(TextLabel_buddylistOfflineFont, tempFont);
}

/******************************************************************************
 * set the default buddy list SignOn Font
 ******************************************************************************/
void TextOptionsImp::setDefaultbuddylistSignOnFont(){
  QFont tempFont;
	tempFont = qApp->font();
	tempFont.setWeight( QFont::Bold );
	i_aimSettings->buddylistFontSettings->buddylist_SignOnFont = tempFont;
	updateLabel(TextLabel_buddylistSignOnFont, tempFont);
}

/******************************************************************************
 * set the default buddy colors
 ******************************************************************************/
void TextOptionsImp::setDefaultBuddyColors(){
  i_aimSettings->chatColorSettings->chat_buddyText_color.setRgb(0,0,0);
  i_aimSettings->chatColorSettings->chat_buddyName_color.setRgb(128,0,0);
  i_aimSettings->chatColorSettings->chat_buddybg_color.setRgb(255,255,255);
  
  QPixmap color;
  color.resize(40,20);
  color.fill(i_aimSettings->chatColorSettings->chat_buddyText_color);
  chat_color_btext->setPixmap(color);  
  color.fill(i_aimSettings->chatColorSettings->chat_buddyName_color);
  chat_color_bname->setPixmap(color);
  color.fill(i_aimSettings->chatColorSettings->chat_buddybg_color);
  chat_color_bbcolor->setPixmap(color);
}

/******************************************************************************
 * set the default user colors
 ******************************************************************************/
void TextOptionsImp::setDefaultUserColors(){
  i_aimSettings->chatColorSettings->chat_yourText_color.setRgb(0,0,0);
  i_aimSettings->chatColorSettings->chat_yourName_color.setRgb(0,60,128);
  i_aimSettings->chatColorSettings->chat_yourbg_color.setRgb(255,255,255);
  
  QPixmap color;
  color.resize(40,20);
  color.fill(i_aimSettings->chatColorSettings->chat_yourText_color);
  chat_color_ytext->setPixmap(color);  
  color.fill(i_aimSettings->chatColorSettings->chat_yourName_color);
  chat_color_yname->setPixmap(color);
  color.fill(i_aimSettings->chatColorSettings->chat_yourbg_color);
  chat_color_ybcolor->setPixmap(color);
}

//TextOptionsImp.cpp





















