/***************************************************************************
                           profileoptionsimp.cpp
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "profileoptionsimp.h"
#include <qlineedit.h>
#include <qgroupbox.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
ProfileOptionsImp::ProfileOptionsImp(QWidget *parent, const char *name) : ProfileOptions( parent,name,false ){
	i_aimSettings = setup::settings();
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
ProfileOptionsImp::~ProfileOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void ProfileOptionsImp::updateData(){
	i_aimSettings = setup::settings();

	if(i_aimSettings->login_name.isEmpty()){
		this->setEnabled(FALSE);
		profile_edit->clear();
		ProfileGroupBox->setTitle( i18n("User Profile") );

		return;
	} else {
    QString qp = "User Profile for " + i_aimSettings->login_name;
    ProfileGroupBox->setTitle( i18n(qp.latin1()) );
		setup::instance()->readProfile(
i_aimSettings->login_name ); 		this->setEnabled(TRUE);
	}
		
	profile_edit->setText( setup::instance()->readProfile(i_aimSettings->login_name) );
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void ProfileOptionsImp::getData(){
	if(i_aimSettings->login_name.isEmpty()){
		return;
	}
		
	if(!i_aimSettings->login_name.isEmpty())
	  setup::instance()->saveProfile(i_aimSettings->login_name, profile_edit->text());
}

// ProfileOptionsImp.cpp
