/***************************************************************************
                               options.cpp
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#include "options.h"
#include "klocale.h"

#include <qframe.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qlabel.h>
#include <kiconloader.h>

#include "chatoptionsimp.h"
#include "awayoptionsimp.h"
#include "mainwindowoptionsimp.h"
#include "profileoptionsimp.h"
#include "soundoptionsimp.h"
#include "networkoptionsimp.h"
#include "permitdenyoptionsimp.h"
#include "textoptionsimp.h"

/* 
 *  Constructs a options which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
options::options( QWidget* parent,  const char* name, TAim *connection, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl ){
	/*
  i_aimSettings = aimSettings;
	*/
	i_aimSettings = setup::settings();
	if ( !name )
	  setName( "options" );
	resize( 555, 510 );
  setCaption( i18n( "Kinkatta - Options" ) );
  setSizeGripEnabled( TRUE );
  
	LayoutGlobal = new QVBoxLayout( this ); 
  LayoutGlobal->setSpacing( 6 );
  LayoutGlobal->setMargin( 10 );

	//this->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)7, listBox->sizePolicy().hasHeightForWidth() ) );

	LayoutItem = new QHBoxLayout; 
  LayoutItem->setSpacing( 6 );
  LayoutItem->setMargin( 0 );

  listBox = new QListBox( this, "listBox" );
	item1 = new IconListItem( listBox, UserIcon("config_network"), "Network");
  item2 = new IconListItem( listBox, UserIcon("config_chat"), "Chat");
  item3 = new IconListItem( listBox, UserIcon("config_main"), "Main Window");
  item4 = new IconListItem( listBox, UserIcon("config_sound"), "Sound");
  item5 = new IconListItem( listBox, UserIcon("config_deny"), "Permit/Deny");
  item6 = new IconListItem( listBox, UserIcon("config_away"), "Away");
  item7 = new IconListItem( listBox, UserIcon("config_profile"), "Profile");
  item8 = new IconListItem( listBox, UserIcon("config_text"), "Text");
  
	listBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)7, listBox->sizePolicy().hasHeightForWidth() ) );
	//listBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)7, listBox->sizePolicy().hasHeightForWidth() ) );
  listBox->setMinimumSize(90,455);

	int iw = listBox->width() - 5;
	item1->expandMinimumWidth( iw );
	item2->expandMinimumWidth( iw );
	item3->expandMinimumWidth( iw );
	item4->expandMinimumWidth( iw );
	item5->expandMinimumWidth( iw );
	item6->expandMinimumWidth( iw );
	item7->expandMinimumWidth( iw );
  item8->expandMinimumWidth( iw );

	//listBox->setWidth(listBox->width()+2);
	listBox->setHScrollBarMode ( QScrollView::AlwaysOff );
  listBox->setMaximumWidth(iw);
	
	listBox->setSelected( 0, true);
	LayoutItem->addWidget( listBox );
  
	LayoutItemWHeader = new QVBoxLayout; 
  LayoutItemWHeader->setSpacing( 6 );
  LayoutItemWHeader->setMargin( 0 );
  LayoutItem->addItem(LayoutItemWHeader);
					
	title = new QLabel(this, "noname");
	QFont TextLabel_font(  title->font() );
  TextLabel_font.setBold( TRUE );
  title->setFont( TextLabel_font ); 
  title->setText("Network Settings");
	LayoutItemWHeader->addWidget( title);
  line = new QFrame(this, "noname");
  line->setGeometry( QRect(10, 10, 180, 5 ) );
  line->setFrameStyle( QFrame::HLine | QFrame::Plain );
	LayoutItemWHeader->addWidget( line );
		
 	network = new NetworkOptionsImp( this, "NetworkPage");
	LayoutItemWHeader->addWidget(network);
	chat = new ChatOptionsImp(this, "ChatPage");
	connect(chat, SIGNAL(chatToolbarUpdated()), this, SIGNAL(chatToolbarUpdated()));
  connect(chat, SIGNAL(chatRoomToolbarUpdated()), this, SIGNAL(chatRoomToolbarUpdated()));
  chat->hide();
	LayoutItemWHeader->addWidget(chat);
	main = new MainWindowOptionsImp(this, "MainPage");
  main->hide();
 	LayoutItemWHeader->addWidget(main);
  sound = new SoundOptionsImp( this, "SoundPage");
  sound->hide();
	LayoutItemWHeader->addWidget(sound);
  deny = new PermitDenyOptionsImp( this, "DenyPage");
  deny->i_connection = connection;
  deny->hide();
	LayoutItemWHeader->addWidget(deny);
	away = new AwayWindowOptionsImp( this, "AwayPage");
  away->hide();
	LayoutItemWHeader->addWidget(away);
  text = new TextOptionsImp( this, "TextPage");
  text->hide();
  LayoutItemWHeader->addWidget(text);
	profile = new ProfileOptionsImp( this, "ProfilePage");
  profile->hide();
        
  LayoutItemWHeader->addWidget(profile);
 
	
	LayoutHelpWLine = new QVBoxLayout; 
  LayoutHelpWLine->setSpacing( 6 );
  LayoutHelpWLine->setMargin( 0 );
  line2 = new QFrame(this, "noname");
  line2->setGeometry( QRect(10, 10, 180, 5 ) );
  line2->setFrameStyle( QFrame::HLine | QFrame::Plain );
  LayoutHelpWLine->addWidget( line2 );

  Layout1 = new QHBoxLayout; 
  Layout1->setSpacing( 6 );
  Layout1->setMargin( 0 );
  
  buttonDefault = new QPushButton( this, "buttonDefault" );
  buttonDefault->setText( i18n( "&Default" ) );
  buttonDefault->setAutoDefault( TRUE );
  Layout1->addWidget( buttonDefault );
  connect(buttonDefault, SIGNAL(clicked()), this, SIGNAL(setDefault()));

  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout1->addItem( spacer );

  buttonApply = new QPushButton( this, "buttonApply" );
  buttonApply->setText( i18n( "&Apply" ) );
  buttonApply->setAutoDefault( TRUE );
  Layout1->addWidget( buttonApply );

  buttonOk = new QPushButton( this, "buttonOk" );
  buttonOk->setText( i18n( "&OK" ) );
  buttonOk->setAutoDefault( TRUE );
  buttonOk->setDefault( TRUE );
  Layout1->addWidget( buttonOk );

  buttonCancel = new QPushButton( this, "buttonCancel" );
  buttonCancel->setText( i18n( "&Cancel" ) );
  buttonCancel->setAutoDefault( TRUE );
  Layout1->addWidget( buttonCancel );
  LayoutHelpWLine->addLayout(Layout1);
	
	LayoutGlobal->addItem(LayoutItem);
	LayoutGlobal->addItem(LayoutHelpWLine);
	
	// signals and slots connections
  connect( listBox, SIGNAL(selectionChanged()), this, SLOT(optionIconSelected()));
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( okClicked() ) );
  connect( buttonApply, SIGNAL( clicked() ), this, SLOT( applyClicked() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( cancelClicked() ) );

  this->setMinimumSize(560,540);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
options::~options(){
    // no need to delete child widgets, Qt does it all for us
}

void options::okClicked(){
	applyClicked();
	hide();
}

void options::cancelClicked(){
  hide();
}

void options::applyClicked(){
  sound->getData();
  network->getData();
  deny->getData();
  away->getData();
  profile->getData();
  chat->getData();
	main->getData();
  text->getData();
  emit (dataUpdated());
  emit (exiting());
}

void options::updateData(){
	/*
	i_aimSettings = aimSettings;
	*/
	i_aimSettings = setup::settings();

	sound->updateData();
  network->updateData();
	deny->updateData();
	away->updateData();
	profile->updateData();
	chat->updateData();
  text->updateData();
	main->updateData();
}

void options::optionIconSelected(){
	int number = listBox->currentItem();
	network->hide();
  chat->hide();
  main->hide();
  sound->hide();
  deny->hide();
  away->hide();
  text->hide();
  profile->hide();
  if (number == 0){
    network->show();
		title->setText(i18n("Network Settings"));
	}
	if (number == 1){
    chat->show();
		title->setText(i18n("Chat Settings"));
	}
	if (number == 2){
    main->show();
		title->setText(i18n("Main Window Settings"));
	}
  if (number == 3){
    sound->show();
		title->setText(i18n("Sound Settings"));
	}
  if (number == 4){
    deny->show();
		title->setText(i18n("Permit/Deny Settings"));
	}
  if (number == 5){
    away->show();
		title->setText(i18n("Away Settings"));
	}
  if (number == 6){
    profile->show();
		title->setText(i18n("Profile Settings"));
	}
  if (number == 7){
    text->show();
		title->setText(i18n("Text Settings"));
	}
}







IconListItem::IconListItem( QListBox *listbox, const QPixmap &pixmap, 
			    const QString &text )
  : QListBoxItem( listbox )
{
  mPixmap = pixmap;
  if( mPixmap.isNull() == true ){
    mPixmap = defaultPixmap();
  }
  setText( text );
  mMinimumWidth = 0;
}


int IconListItem::expandMinimumWidth( int width ){
  mMinimumWidth = QMAX( mMinimumWidth, width );
  return( mMinimumWidth );
}


const QPixmap &IconListItem::defaultPixmap(){
  static QPixmap *pix=0;
  /*
	if( pix == 0 )
  {
    pix = new QPixmap( 32, 32 );
    QPainter p( pix );
    p.eraseRect( 0, 0, pix->width(), pix->height() );
    p.setPen( Qt::red );
    p.drawRect ( 0, 0, pix->width(), pix->height() );
    p.end();

    QBitmap mask( pix->width(), pix->height(), true );
    mask.fill( Qt::black );
    p.begin( &mask );
    p.setPen( Qt::white );
    p.drawRect ( 0, 0, pix->width(), pix->height() );
    p.end();

    pix->setMask( mask );
  }*/
  return( *pix );
}


void IconListItem::paint( QPainter *painter ){
  QFontMetrics fm = painter->fontMetrics();
  int wt = fm.boundingRect(text()).width();
  int wp = mPixmap.width();
  int ht = fm.lineSpacing();
  int hp = mPixmap.height();  
  
  painter->drawPixmap( (mMinimumWidth-wp)/2 -4, 5, mPixmap );
  if( text().isEmpty() == false ){
    painter->save();
    QFont f( painter->font() );
    f.setBold( true );
    painter->setFont(f);
    painter->drawText( (mMinimumWidth-wt)/2 -4, hp+ht+5, text() );
    painter->restore();
  }
}

int IconListItem::height( const QListBox *lb ) const{
  if( text().isEmpty() == true ){
    return( mPixmap.height() );
  }
  else{
    return( mPixmap.height() + lb->fontMetrics().lineSpacing()+10 );
  }
}


int IconListItem::width( const QListBox *lb ) const{
  int wt = lb->fontMetrics().boundingRect(text()).width()+10;
  int wp = mPixmap.width() + 10;
  int w  = QMAX( wt, wp );
  return( QMAX( w, mMinimumWidth ) );
}





