/***************************************************************************
                                newpounceimp.h
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef NEWPOUNCEIMP_H
#define NEWPOUNCEIMP_H

#include <newpounce.h>
#include <qstring.h>
#include <qcombobox.h>

/**
 * Stores data on a pounce instance.
 */
struct pounce{
  /**
   * Buddy name
   */
  QString buddyName;

  /**
   * Pounce on sign-on
   */
  bool signOn;

  /**
   * Pounce on return from away
   */
  bool returnAway;

  /**
   * Pounce on return from idle
   */
  bool returnIdle;

  /**
   * Pounce on open chat (?)
   */
  bool openChat;

  /**
   * Whether to send message
   */
  bool sendMessage;

  /**
   * Message to send
   */
  QString message;


  /**
   * Execute a command on pounce
   */
	bool execCommand;

  /**
   * Command to execute
   */
	QString command;

  /**
   * Remove this pounce after activation
   */
	bool doNotRemove;

  /**
   * The delete menu ID
   */
  int deleteMenuId;

  /**
   * The edit menu ID
   */
  int editMenuId;

  /**
   * Whether to hide
   */
  bool hidden;

  /**
   * The signon sound (?)
   */
  QString signOnSound;

  /**
   * The signoff sound (?)
   */
  QString signOffSound;

  /**
   * Whether to ignore settings (?)
   */
  bool ignoreSettings; 
};

/**
 * This class handles the NewPounce dialog.
 *@author Benjamin Meyer
 */
class NewPounceImp : public NewPounce  {

Q_OBJECT
	
signals:
/**
 * Emitted once the pounce to be added has been verified.
 */ 
  void addPounce(pounce newPounce);

public:
/**
 * Constructor.
 * @param parent the parent widget
 * @param name the name of the widget
 * @param pounceName the name of the pounce
 * Creates a new pounce for the buddy specified by name.
 */
  NewPounceImp(QWidget *parent=0, const char *name=0, QString pounceName=0);

  /**
   * Destructor.
   */
  ~NewPounceImp();

  /**
   * Sets information from this pounce
   * @param newpounce the pounce to set
   * Sets the window pounce information for this pounce.
   */
  void setPounce(pounce *newpounce);

private slots:
  /**
   * Called to copy the settings from the form.
   */
  void verify();

/**
 * Called to close the window.
 */
  void cancelAndClose();

};

#endif

// NewPounceImp.h
