/***************************************************************************
                          				main.cpp
                             -------------------
    begin                : Sun Feb 13 01:05:24 EST 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kinkatta.h"
#include <kapp.h>
#include "chatwindow.h"
#include <string.h>
#include <kcmdlineargs.h>

#include <kaboutdata.h>
#include <klocale.h>

int main(int argc, char *argv[]){
  bool disableAutoCheck = false;
  bool baseFont = false;
  bool enableDebugWindow = false;
  int baseFontParam = 0;
  bool baseFontSize = false;
  int baseFontSizeParam = 0;
  if (argc >= 0){
    if (strcmp(argv[1],"-help")==0 || strcmp(argv[1],"--help")==0 || strcmp(argv[1],"-?")==0){
    printf("Usage: kinkatta [OPTION...]\n"
"\n"
"Help options\n"
"  -?, -help --help            Show this help message.\n"
"\n"
"Kinkatta Options\n"
"  --disable-new-version-check Kinkatta will not check for a new version on login.\n"
"  --enable-debug-window       Brings up the debug window to see outgoing and\n"
"                              incoming data.\n"
"\n"
"QT Options\n"
"  -style=[style]              Sets the application GUI style/theme. Possible\n"
"                              values are motif, windows, and platinum.\n"
"  -session=[session]          Restores the application from an earlier session.\n"
"\n"
"QT X11 Options\n"
"  -display [display]          Sets the X display (default is $DISPLAY).\n"
"  -geometry [geometry]        Sets the client geometry of the main widget.\n"
"  -fn or -font [font]         Defines the application font.\n"
"  -bg or -background [color]  Sets the default background color and an\n"
"                              application palette (light and dark shades are \n"
"                              calculated).\n"
"  -fg or -foreground [color]  Sets the default foreground color.\n"
"  -btn or -button [color]     Sets the default button color.\n"
"  -name [name]                Sets the application name.\n"
"  -title [title]              Sets the application title (caption).\n"
"  -visual [TrueColor]         Forces the application to use a TrueColor visual\n"
"                              on an 8-bit display.\n"
"  -ncols [count]              Limits the number of colors allocated in the\n"
"                              color cube on a 8-bit display, if the application\n"
"                              is using the QApplication::ManyColor color\n"
"                              specification.  If count is 216 then a 6x6x6\n"
"                              color cube is used (ie. 6 levels of red, 6 of\n"
"                              green, and 6 of blue); for other values, a cube\n"
"                              approximately proportional to a 2x3x1 cube\n"
"                              is used.\n"
"  -cmap                       Causes the application to install a private color\n"
"                              map on an 8-bit display.\n"
);
      exit(1);
    }

    int i=1;
    while ( i < argc ) {
      if ( strcmp( argv[i],"--disable-new-version-check" ) == 0 ) {
        disableAutoCheck = true;
      }
      if ( strcmp( argv[i],"--enable-debug-window" ) == 0 ) {
	enableDebugWindow = true;
      }


      if ( strcmp( argv[i],"--base-font" ) == 0 ) {
	      if ((i + 1 ) < argc) {
	        baseFont = true;
        	baseFontParam = i + 1;
	      }
      }

      if ( strcmp( argv[i],"--base-font-size" ) == 0 ) {
	      if ((i + 1 ) < argc) {
	        baseFontSize = true;
        	baseFontSizeParam = i + 1;
	      }
      }

      i++;
    }
  }


  // about data
	KAboutData aboutData("kinkatta", I18N_NOOP("Kinkatta"), "1.0",
	                     I18N_NOOP("AOL Instant Messenger Client"), KAboutData::License_LGPL, 0,
	                     "http://kinkatta.sourceforge.net/", "ben@meyerhome.net");
	aboutData.addAuthor("Benjamin Meyer", I18N_NOOP("Original author"), "ben@meyerhome.net");

	// SIGPIPE gives me problems
	//(void)signal(SIGPIPE, SIG_IGN);

	// command line
	KCmdLineArgs::init(argc, argv, &aboutData);
	// add our options
	static KCmdLineOptions options[]=
	{
		{"disable-new-version-check", I18N_NOOP("Kinkatta will not check for a new version on login."), 0 },
		{"enable-debug-window", I18N_NOOP("Brings up the debug window to see outgoing and incoming data."),0 }
	};
        KCmdLineArgs::addCmdLineOptions(options);

	// let's make an application
	//if(!KitApp::start()) return 0;
	//KitApp app;
	//return app.exec();

  KApplication a(argc, argv);
  if (baseFont) {
	if (baseFontSize) {
	  KApplication::setFont( QFont(argv[baseFontParam], atoi(argv[baseFontSizeParam])) );
	} else {
  	KApplication::setFont( QFont(argv[baseFontParam], atoi("12")) );
    }
  }
  Kinkatta *kinkatta = new Kinkatta(0, "Kinkatta", enableDebugWindow);
  kinkatta->autoUpdateCheck = !disableAutoCheck;
  QObject::connect(kinkatta, SIGNAL(quit()), &a, SLOT(quit()));
  kinkatta->show();
  a.setMainWidget(kinkatta);
  return a.exec();
}

