/***************************************************************************
                          login.h  -  description
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 * Login Box.  Ask for Name and Password.  Starts SignOn proccess.  Options
 * can also be brought up from here.
 ***************************************************************************/

#ifndef LOGIN_H
#define LOGIN_H

#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qcombobox.h>
#include "setup.h"
#include "browser.h"
#include <qvariant.h>
#include <qlayout.h> 

/**
 * A login box.  Asks for name and passwords.  Starts the signon
 * process.  Options can be brought up from here.
 * @author Benjamin Meyer
 */

class Login : public QWidget  {
  Q_OBJECT

  public:
  /**
   * Constructor.
   * @param parent the parent widget
   * @param name the name
   */
  Login(QWidget *parent=0, const char *name=0);

  /**
   * Destructor.
   */
  ~Login();

  /**
   * Browser instance.
   * Used to retreive data from HTTP servers.
   */
  Browser *browser;

  private:
  /**
   * Settings data
   */
  settings_t *i_aimSettings;

  /**
   * Saves password in settings.
   * @param user specifies which user's password should be saved
   * Saves the password to the settings data.
   */
    void savePassword(QString user);

    /**
     * Retreives a user's password.
     * @param user specifies which user's password should be retreived
     * Retreives the user's password from the settings data.  If no
     * password was found, the dialog is not changed.
     */
    void readPassword(QString user);      	      

    /**
     * Clears a user's password
     * @param user specifies which user's password should be cleared
     * Removes a user's password from the settings data.
     */
    void removePassword(QString user);

  signals:
    /**
     * Emitted when the setup button is clicked.
     */
    void setupClicked();

    /**
     * Emitted when the signon button is clicked.
     */
    void signOnClicked();

  private slots:
    void moveToPass(int);
    void newName(const QString &name );
	
		void enableDisableButton( const QString &);
	
    void SetupClicked();
    void toggleAuto(bool value);
    void toggleSave(bool value);
    void initDialog();
	
  public slots:
    /**
     * Called when settings are changed.
     */
    void updateSettings();
  /**
   * Called when the signon button is clicked.
   */
    void SignOnClicked();
 
  private:
    QLabel *version;
    QLabel *logoImage;
    QLabel *aolnameL;
    QLabel *aolpassL;
    QComboBox *aolName;
    QLineEdit *aolPass;
    QCheckBox *save;
    QCheckBox *autoLogin;
    QPushButton *setupButton;
    QPushButton *signOn;

	protected:
		QHBoxLayout* Layout5;
    QHBoxLayout* Layout2;
    QHBoxLayout* Layout3;
    QHBoxLayout* Layout4;
		QVBoxLayout* Layout1;

};

#endif

// login.h

