/***************************************************************************
                         				kinkattaviewlist.h
                             -------------------
    begin                : Fri Feb 15 2001
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KINKATTAVIEWLIST_H
#define KINKATTAVIEWLIST_H

#include <qwidget.h>
#include <klistview.h>
#include <qevent.h>
#include <qcursor.h>
#include <qtooltip.h>

#include "setup.h"
#include <qlineedit.h>

/**
  *@author Benjamin Meyer
  */

/**
  * When you edit a buddy this is what pops up.
  */
class EditBox : public QLineEdit {
  Q_OBJECT

  //signals:
    //void returnPressed();
  
  public:
    EditBox(QWidget *parent=0, const char *name=0);
    ~EditBox();
    int focus;
    bool alias;
		
  protected:	
    void focusOutEvent ( QFocusEvent * );

};

class BuddyListWindowItem : public QListViewItem {
	public:
		BuddyListWindowItem(KListView *, QString);
		BuddyListWindowItem(QListViewItem *, QString);
		~BuddyListWindowItem();
		enum Decoration { Online, Offline, SignOn } ;
    QString name;
		
		int width( const QFontMetrics& , const KListView* , int ) const;
		void updateFontSettings();
		
		void setDecoration(int);
		int decoration();

		void paintCell(QPainter *, const QColorGroup &, int , int , int );
	protected:
		int mDecoration;
		buddylist_Font_Settings *fontSettings;

};

class DynamicTip : public QToolTip
{
public:
    DynamicTip( QWidget * parent );

protected:
    void maybeTip( const QPoint & );
};

class KinkattaListView : public KListView {
  Q_OBJECT

  signals:
		void removeBuddy(QString);
		void removeFolder(QString);
    void moveItem(QListViewItem *item, QListViewItem *newFolder);

  public:
    KinkattaListView(QWidget *parent=0, const char *name=0);
    ~KinkattaListView();

		EditBox *buddyEdit;
    BuddyListWindowItem *currentItem();
    QString currentName();
		bool checkIfFolder(QListViewItem* selected);
    toolTipData tip( const QPoint & p );

	private:
	  QListViewItem *currentSelectedItem;
	  QCursor internalCursor;
    DynamicTip * t;

	protected:
		void keyPressEvent(QKeyEvent *event);
    void contentsMouseReleaseEvent(QMouseEvent* event);
    void focusOutEvent( QFocusEvent * );

	private slots:
		void itemPressed(QListViewItem *item);
};


#endif
// KinkattaListView.h


