/***************************************************************************
			                    docking.h  -  description
			                       -------------------
		begin                : May 10 2001
		copyright            : (C) 2001 by Dimi Shahbaz
		email                : dshahbaz@ucla.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <qtooltip.h>
#include <qdir.h>
#include <qpoint.h>
#include <kpopupmenu.h>
#include <kwin.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <ksystemtray.h>
#include <kdockwindow.h>

class DockWidget : public KDockWindow /*KSystemTray*/{
	Q_OBJECT
public:
	DockWidget(QWidget *parent = 0, const char *name=0);
	~DockWidget();
	KPopupMenu *awayMenu;
	
signals:
	void hideKinkatta();
	void showKinkatta();
	void hideAll();
	void showAll();
	void showKinkattaPrefs();
	void exitKinkatta();
	void tryToConnect();
	void logoff();
	void backClicked();


protected:
	void paintEvent(QPaintEvent *e);

public slots:
	void connectionChanged(int);

private slots:
	void signOnClicked();
	void showKinkattaClicked();
	void showAllClicked();
	void mousePressEvent(QMouseEvent *e);
	void paintIcon();

private:
	bool kinkattaVisible;
	bool allVisible;
	int connectionState; //TAIM_(AWAY|ONLINE|OFFLINE)
	int showKinkattaID;
	int showAllKinkattaID; //this is for visibility of all Kinkatta windows.
	int signonID;
	int awayMenuID;

	KPopupMenu *popup_m;

	QPixmap dock_offline_pixmap;
	QPixmap dock_online_pixmap;
	QPixmap dock_away_pixmap;
	QPixmap signonIcon;
	QPixmap signoffIcon;

};

#endif

