/***************************************************************************
			                    docking.cpp  -  description
			                       -------------------
		begin                : May 10 2001
		copyright            : (C) 2001 by Dimi Shahbaz
		email                : dshahbaz@ucla.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qdir.h>
#include <qpoint.h>
#include <kwin.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <kapp.h>

#include "kinkattadock.h"
#include "taim.h"

DockWidget::DockWidget(QWidget *parent, const char *name)
	: KDockWindow /*KSystemTray*/(parent, name){

	awayMenu = NULL;
	awayMenuID = -1;

	kinkattaVisible = TRUE;
	allVisible = TRUE;
	connectionState = TAIM_OFFLINE;

	// load pixmaps
	dock_online_pixmap = SmallIcon("dock_online");
	dock_offline_pixmap = SmallIcon("dock_offline");
	dock_away_pixmap = SmallIcon("dock_away");
	signonIcon = SmallIcon("connect_established");
	signoffIcon = SmallIcon("connect_no");
	//show();

	// popup menu for right mouse button
	popup_m = new KPopupMenu();
	popup_m->insertTitle(i18n("Kinkatta"));
	showKinkattaID = popup_m->insertItem(i18n("&Show"),
				 this, SLOT(showKinkattaClicked()));
	/*
	showAllKinkattaID = popup_m->insertItem(i18n("Show &All"),
				 this, SLOT(showAllClicked()));
	*/
	popup_m->insertSeparator();
	popup_m->insertItem(SmallIcon("configure"), i18n("&Preferences..."), this, SIGNAL(showKinkattaPrefs()));
	popup_m->insertItem(SmallIcon("exit"), i18n("E&xit"),
		      this, SIGNAL(exitKinkatta()));
	signonID = popup_m->insertItem(signonIcon, i18n("Sign&on"),
				 this, SLOT(signOnClicked()));


}

DockWidget::~DockWidget() {

}

void DockWidget::signOnClicked(){
	if(connectionState == TAIM_OFFLINE)
		emit tryToConnect();
	else // connectionState == TAIM_ONLINE | TAIM_AWAY
		emit logoff();
}

void DockWidget::paintEvent (QPaintEvent *) {
	paintIcon();
}

void DockWidget::paintIcon () {
        this->erase();
	if(connectionState == TAIM_OFFLINE)
		bitBlt(this, 0, 0, &dock_offline_pixmap);
	else if (connectionState == TAIM_ONLINE)
		bitBlt(this, 0, 0, &dock_online_pixmap);
	else if (connectionState == TAIM_AWAY)
		bitBlt(this, 0, 0, &dock_away_pixmap);
}

void DockWidget::mousePressEvent(QMouseEvent *e) {
	// open/close connect-window on right mouse button
	if ( e->button() == LeftButton ) {
		showKinkattaClicked();
	}

	// open popup menu on left mouse button
	if ( e->button() == RightButton ) {
		QString text;

		if(kinkattaVisible)
			text = i18n("&Hide");
		else //!kinkattaVisible
			text = i18n("&Show");
		popup_m->changeItem(showKinkattaID, text);

		/*
		if(allVisible)
			text = i18n("Hide &All");
		else //!allVisible
			text = i18n("Show &All");
		popup_m->changeItem(showAllKinkattaID, text);
		*/

		if( (connectionState == TAIM_ONLINE) || (connectionState == TAIM_AWAY) )
			text = i18n("Signo&ff");
		else //connectionState == TAIM_OFFLINE
			text = i18n("Sign&on");
		popup_m->changeItem(signonID, connectionState == TAIM_OFFLINE ? signonIcon : signoffIcon , text);


		popup_m->popup(e->globalPos());
		popup_m->exec();
	}

}

void DockWidget::connectionChanged(int c){
	connectionState = c;

	switch(connectionState){
		case TAIM_OFFLINE:
			if(awayMenuID != -1)
				popup_m->removeItem(awayMenuID);
			awayMenuID = -1;
			break;
		case TAIM_ONLINE:
			if(awayMenuID != -1)
				popup_m->removeItem(awayMenuID);
			awayMenuID = popup_m->insertItem(SmallIcon("buddy_away"), "&Away", awayMenu);
			break;
		case TAIM_AWAY:
			if(awayMenuID != -1)
				popup_m->removeItem(awayMenuID);
			awayMenuID = popup_m->insertItem(SmallIcon("buddy_away"), "&Back", this, SIGNAL(backClicked()));
			break;
	} //switch

	paintIcon();
}

void DockWidget::showKinkattaClicked(){
	if(kinkattaVisible)
		emit hideKinkatta();
	else
		emit showKinkatta();

	kinkattaVisible = !kinkattaVisible;

}

void DockWidget::showAllClicked(){
	if(allVisible)
		emit hideAll();
	else
		emit showAll();

	allVisible = !allVisible;
}


