/******************************************************************************
                                   kinkatta.h
                             -------------------
    begin                : Sat May 20 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ******************************************************************************/

/******************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.
 *
 ******************************************************************************/

/******************************************************************************
 * Main QObject for application.  All other windows are kept as children of
 * this class.  They are created and distroyed when needed.  Data pointer are
 * passed to the window that are needed.  These include the connection and
 * the settings.
 ******************************************************************************/

#ifndef KINKATTA_H
#define KINKATTA_H

#include <qmainwindow.h> 
#include "taim.h"               // the toc protocal object
#include "setup.h"		          // AIM Settings
#include "tbuddylist.h"
#include "options.h"
#include "kinkattadock.h"

class QMultiLineEdit;
class QProgressDialog;
class Browser;
class Login;
class BuddyListWindow;

/**
  *@author Benjamin Meyer
  */

class Kinkatta : public QMainWindow  {
  Q_OBJECT

  signals:
    void quit();
    void settingsChanged();

  public:
    Kinkatta(QWidget* parent=0, const char *name=0, bool enableDebug=0);
    ~Kinkatta();
    bool autoUpdateCheck;

  private:
    bool loginIn;
		Browser *browser;
    Login *loginDialog;
    BuddyListWindow *buddyWindow;
    options *optionsDialog;

    QString lastLoginName;
    QMultiLineEdit *debugWindow;
    bool isDebugWindow;

    settings_t *i_aimSettings;
    TAim *connection;
    bool checkForUpdateReportErrors;
    bool loggingOnError;
    bool quiting;
    bool manualLogOff;
		QProgressDialog *progress;

		//Docking stuff
		DockWidget *dockWidget;
		QPoint globalPosition;

  private slots:
		void savePounce();
    void debugDataIn(QString);
    void changeSize(int, int);
    void displayError(QString error);
    void Quit();
    void Connected();
    void TryToConnect();
    void Disconected();
    void BringUpSetup();
    void SaveAimSettings();
    void Logoff();
    void watchConnection(int);
    void setProfile();
    void checkForUpdates();
    void checkForUpdatesWError();
    void setDefaultSettings();
		void setNick(QString);

		//Docking stuff
		void showKinkatta();
		void hideKinkatta();
		
		// progress bar for aim
		void initProgress(int, int, QString);
		void updateProgress(int, QString);
		void endProgress(void);
 
  protected:
    void closeEvent(class QCloseEvent *);
    void resizeEvent( QResizeEvent *e );
};

#endif

// kinkatta.h



