/******************************************************************************
                                  kinkatta.cpp
                             -------------------
    begin                : Sat May 20 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ******************************************************************************/

/******************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.
 *
 ******************************************************************************/

/******************************************************************************
 * Main QObject for application.  All other windows are kept as children of
 * this class.  They are created and distroyed when needed.  Data pointer are
 * passed to the window that are needed.  These include the connection and
 * the settings.
 ******************************************************************************/

#include "kinkatta.h"
#include <kapp.h>
#include "qmessagebox.h"
#include <kiconloader.h>
#include "aim.h"
#include <stdlib.h>
#include <qtextstream.h>
#include <qfile.h>
#include <errno.h>
#include <qnamespace.h>
#include <qprogressdialog.h>
#include "browser.h"
#include "login.h"              // AIM Login Window
#include "buddylistwindow.h"    // AIM Buddy Lists Window
#include <qpixmap.h>
#include <kpassdlg.h>
#include <kwin.h>
#include <kio/netaccess.h>

#include <qpixmap.h>
#include <qmultilineedit.h>
/******************************************************************************
 * Constructor
 ******************************************************************************/
Kinkatta::Kinkatta(QWidget* parent, const char *name, bool enableDebug):QMainWindow(parent, name) {
  autoUpdateCheck = true;
  loggingOnError = false;
  quiting = false;
  manualLogOff = false;
  progress = NULL;
  loginIn = false;
  optionsDialog = NULL;
  checkForUpdateReportErrors = false;
  browser = new Browser();
  //QMessageBox::information(this, "Message","1", QMessageBox::Ok);
  this->setIcon(SmallIcon("kinkatta"));
  connect(this, SIGNAL(settingsChanged()), this, SLOT(SaveAimSettings()));

  // Get settings from file and set them to the current aimSettings
  setup::instance()->read();
  i_aimSettings = setup::settings();
  if (i_aimSettings->main_browser != "netscape"){
    browser->setBrowser(2);
    browser->otherBrowser = i_aimSettings->main_browser;
  }
  // init the connection
  connection = new TAim(this, "Connection");
  connect(connection, SIGNAL(statusChanged(int)), this, SLOT(watchConnection(int)));
  connect(connection, SIGNAL( displayError(QString)), this, SLOT( displayError(QString)));
  connect(connection, SIGNAL(debugDataIn(QString)), this, SLOT(debugDataIn(QString)));
  connect(connection, SIGNAL(nick(QString)), this, SLOT(setNick(QString)));

  connect( connection, SIGNAL(initProgress(int, int, QString)), this, SLOT(initProgress(int, int, QString)) );
  connect( connection, SIGNAL(updateProgress(int, QString)), this, SLOT(updateProgress(int, QString)) );
  connect( connection, SIGNAL(endProgress()), this, SLOT(endProgress()) );


  buddyWindow = new BuddyListWindow(this, "buddyDialog", connection);
  buddyWindow->browser = browser;
  connect(buddyWindow, SIGNAL(quit()), this, SLOT(Quit()));
  connect(buddyWindow, SIGNAL(logOff()), this, SLOT(Logoff()));
  connect(buddyWindow, SIGNAL(showOptions()), this, SLOT(BringUpSetup()));
  connect(buddyWindow, SIGNAL(saveSettings()), this, SLOT(SaveAimSettings()));
  connect(buddyWindow, SIGNAL(set_window(int,int)), this, SLOT(changeSize(int,int)));
  connect(buddyWindow, SIGNAL(checkForNewRelease()), this, SLOT(checkForUpdatesWError()));
  connect(this, SIGNAL(settingsChanged()), buddyWindow, SLOT(settingsChanged()));
  buddyWindow->hide();

  dockWidget = new DockWidget(this, "dockWidget");
  connect(dockWidget, SIGNAL(showKinkattaPrefs()), this, SLOT(BringUpSetup()));
  connect(connection, SIGNAL(statusChanged(int)),
	dockWidget, SLOT(connectionChanged(int)));
  connect(buddyWindow, SIGNAL(statusChanged(int)),
		dockWidget, SLOT(connectionChanged(int)));
  connect(dockWidget, SIGNAL(backClicked()), buddyWindow, SLOT(away_BackForReal()));
  connect(dockWidget, SIGNAL(tryToConnect()), this, SLOT(TryToConnect()));
  connect(dockWidget, SIGNAL(logoff()), this, SLOT(Logoff()));
  connect(dockWidget, SIGNAL(exitKinkatta()), this, SLOT(Quit()));
  connect(dockWidget, SIGNAL(showKinkatta()), this, SLOT(showKinkatta()));
  connect(dockWidget, SIGNAL(hideKinkatta()), this, SLOT(hideKinkatta()));
  dockWidget->awayMenu = buddyWindow->_AwayMenu;
  dockWidget->show();
  //QToolTip::add(dockWidget, "<b>SU</b>P!\n\n<i>OK!</i>!");

  loginDialog = new Login(this, "LoginDialog");

  connect(loginDialog, SIGNAL(setupClicked()), this, SLOT(BringUpSetup()));
  connect(loginDialog, SIGNAL(signOnClicked()), this, SLOT(TryToConnect()));
  connect(loginDialog, SIGNAL(destroyed()), this, SLOT(Quit()));
  connect(this, SIGNAL(settingsChanged()), loginDialog, SLOT(updateSettings()));
  loginDialog->browser = browser;
  loginDialog->hide();

  if (isDebugWindow == true || enableDebug == true){
    isDebugWindow = true;
    SaveAimSettings();
    debugWindow = new QMultiLineEdit(0, "DebugWindow");
    debugWindow->setWordWrap( QMultiLineEdit::WidgetWidth );
    debugWindow->setWrapPolicy( QMultiLineEdit::Anywhere );
    debugWindow->setReadOnly(TRUE);
    debugWindow->setCaption("Kinkatta - Debug Window");
    debugWindow->resize(450,250);
    debugWindow->show();
  }
  else{
    debugWindow = NULL;
  }
  // Set state to Disconected();
  Disconected();
  this->setCaption("Kinkatta");
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
Kinkatta::~Kinkatta(){

}

/******************************************************************************
 * Set the proper nick spacing etc.
 ******************************************************************************/
void Kinkatta::setNick(QString name){
  i_aimSettings->login_name = name;
}

/******************************************************************************
 * When we get data in from the server send it in.  Put it in the debug box
 * one was created.
 ******************************************************************************/
void Kinkatta::debugDataIn(QString data){
  if (isDebugWindow == true && debugWindow != NULL){
    debugWindow->append(data + "\n");
		debugWindow->setCursorPosition( debugWindow->numLines(), 0 );
		debugWindow->repaint(FALSE);
  }
}

/******************************************************************************
 * Called from buddylistwindow to resize the entire widget.
 ******************************************************************************/
void Kinkatta::changeSize(int x, int y){
  this->resize(x,y);
}

/******************************************************************************
 * Network code had an error, display
 ******************************************************************************/
void Kinkatta::displayError(QString error){
  loggingOnError = true;
  if (manualLogOff == true){
		if (error != "Disconnected.")
			QMessageBox::critical(0, "Kinkatta - Error",error, "Ok");
    manualLogOff = false;
	}
  else
	  QMessageBox::critical(0, "Kinkatta - Error",error, "Ok");
}

/******************************************************************************
 * Kinkatta has been disconnected, bring up login screen
 ******************************************************************************/
void Kinkatta::Disconected(){
  if (connection->getStatus() != TAIM_OFFLINE)
    return;

  if(buddyWindow->awayRightNow == true)
      buddyWindow->away_BackForReal();

  buddyWindow->hide();
  buddyWindow->clearPostConnections();
	loginDialog->show();

  this->setMinimumSize(242,220);
  this->resize(242,234);

  qApp->processEvents();
  // Bring up the Login Window
  loginDialog->setFocus();
  this->setCentralWidget(loginDialog);
  loginDialog->updateSettings();
  if (loggingOnError == false)
    if (i_aimSettings->login_enable_auto == true)
      loginDialog->SignOnClicked();
}

/******************************************************************************
 * The Login Screen wants to try to log in.
 ******************************************************************************/
void Kinkatta::TryToConnect(){
  //QCString password;
  //int result = KPasswordDialog::getNewPassword(password, i18n("Password"));


  if (connection->getStatus() != TAIM_OFFLINE)
    return;
  loginIn = true;

  loggingOnError = false;

  // Bring up the SignOn Window
  //save the options again, in case Options was pressed under a different user
  setup::instance()->readProfile( setup::settings()->login_name );

  TBuddyList buddy;
  TBuddyList permit;
  TBuddyList deny;
  int permitStatus;
  setup::instance()->parseBuddyList(setup::settings()->login_name,
	&buddy, &permit, &deny, &permitStatus);

  connection->setBuddyList(buddy);
  connection->setPermitList(permit);
  connection->setDenyList(deny);
  connection->setPermissions(permitStatus);

  // dokeepAlive
  connection->doKeepAlive(true);
  // Idle
  connection->doIdleTime(true);
  // SetCustom server
  connection->useCustomServer(true);
  connection->setCustomServer(setup::settings()->login_server_toc,
		atoi(setup::settings()->login_port_toc.latin1()),
		setup::settings()->login_server_login,
		atoi(setup::settings()->login_port_login.latin1()));

  /*
  // Enable proxy
  if (setup::settings()->proxy_Choice == 2){
    connection->useSocksServer(true);
    connection->setSocksProxy(setup::settings()->proxy_server,atoi(setup::settings()->proxy_port.latin1()));
  }
  */

  // Set UserName
  connection->setUserName( setup::settings()->login_name );
  // set Pass
  connection->setPassword( setup::settings()->login_password );
  // Set UserInfo
  connection->setUserInfo( setup::instance()->readProfile(i_aimSettings->login_name) );
  // setStatus(taim_online)
  connection->setStatus(TAIM_ONLINE);
}

/******************************************************************************
 * Kinkatta is connected to a toc server, Bring up buddylist
 ******************************************************************************/
void Kinkatta::Connected(){
  if (connection->getStatus() != TAIM_ONLINE){
    return;
  }

  this->setMinimumSize(130,50);
  // If this a re-signon with a different user, close the previous users
  // chatwindows.  If this is a re-signon with the same user, leave existing
  // chatwindows open.
  if( lastLoginName != setup::settings()->login_name ){
    buddyWindow->closeExistingChatwindows();
  }
  lastLoginName = setup::settings()->login_name;

  this->setMinimumSize(70,50);
  if (connection->getStatus() != TAIM_OFFLINE){
    // If this a re-signon with a different user, close the previous users
    // chatwindows.  If this is a re-signon with the same user, leave existing
    // chatwindows open.
    if( lastLoginName != setup::settings()->login_name ){
      buddyWindow->closeExistingChatwindows();
    }
    lastLoginName = setup::settings()->login_name;

    // Get rid of the signon window
    //if (setup::settings()->main_noIcons == true)
    int x = (setup::settings()->xSize);
    int y = (setup::settings()->ySize);

		buddyWindow->show();
    this->setCentralWidget(buddyWindow);
		loginDialog->hide();

    if ( (x > 120)  && (y > 250) && (x < 1000) && (y < 2500) ){
      this->resize(x,y);
    }
    else
      this->resize(200,310);
    qApp->processEvents();
    if (setup::settings()->main_mute_on_login == true){
      buddyWindow->startMutePeriod();
    }
    buddyWindow->loadList();
    buddyWindow->loadRecurringPounces();
    if(buddyWindow->awayRightNow == true)
      buddyWindow->away_BackForReal();
    buddyWindow->initOptions();
    SaveAimSettings();
  }
  //This is only set false through a command line option.
  if (connection->getStatus() != TAIM_OFFLINE)
    if (autoUpdateCheck == true)
      checkForUpdates();
}

/******************************************************************************
 * Someone wants the setup window, bring it up.  Saves when exiting.
 * The options window internally handles if changes are made.
 ******************************************************************************/
void Kinkatta::BringUpSetup(){
	// Option Box
  if ( optionsDialog == NULL ) {
    optionsDialog = new options(0, "options dialog", connection);
    optionsDialog->setIcon(SmallIcon("kinkatta"));
    connect(optionsDialog, SIGNAL(dataUpdated()), this, SIGNAL(settingsChanged()));
    connect(optionsDialog, SIGNAL(chatToolbarUpdated()), buddyWindow, SLOT(chatWindow_ToolbarUpdated()));
    connect(optionsDialog, SIGNAL(chatRoomToolbarUpdated()), buddyWindow, SLOT(chatRoom_ToolbarUpdated()));
    connect(optionsDialog, SIGNAL(setDefault()), this, SLOT(setDefaultSettings()));
    optionsDialog->updateData();
	  optionsDialog->show();
  } else {
		/* If we get here, then the optionsDialog != NULL, which means it has
		 * already been allocated/connected up, so we can just updateData, and
		 * show() it.
		 */
		optionsDialog->updateData();
		optionsDialog->show();
	}
}

/******************************************************************************
 * Catches offline signals and acts
 ******************************************************************************/
void Kinkatta::watchConnection(int n){
  if ( n == TAIM_OFFLINE){
    if (quiting == false && loginIn == false)
			Disconected();
	}
  else
		if (loginIn == false)
			Connected();
}

/******************************************************************************
 * Show's the (hidden) widget, after restoring its position
 ******************************************************************************/
void Kinkatta::showKinkatta(){
	setGeometry(globalPosition.x(), globalPosition.y(), width(), height());
	show();

}

/******************************************************************************
 * Saves the global position of this widget, then hides the widget.
 ******************************************************************************/
void Kinkatta::hideKinkatta(){
	QRect globalGeometry = KWin::info( winId() ).frameGeometry;
	globalPosition.setX( globalGeometry.x() );
	globalPosition.setY( globalGeometry.y() );
	hide();
}

/******************************************************************************
 * Main window requests to log off.  Go offline and bring up login window.
 ******************************************************************************/
void Kinkatta::Logoff(){
  manualLogOff = true;
	connection->setStatus(TAIM_OFFLINE);
  Disconected();
	SaveAimSettings();
}

/******************************************************************************
 * Save the current settings to file.
 * Occurs when settings are changed (i.e. login and setup)
 ******************************************************************************/
void Kinkatta::SaveAimSettings(){
  //QString conf;
  setup::instance()->save();
  if (connection->getStatus() != TAIM_OFFLINE){
    setProfile();

    setup::instance()->saveBuddyList( setup::settings()->login_name,
			&(connection->buddyList()), &(connection->permitList()),
			&(connection->denyList()), connection->permissions() );
	}
}

void Kinkatta::savePounce(){
	setup::instance()->savePounces(setup::settings()->login_name,
								setup::settings()->pounces);
}

/***************************************************************************
 * Reset the settings and the update the options
 ***************************************************************************/
void Kinkatta::setDefaultSettings(){
  setup::instance()->resetDefaults();
  optionsDialog->updateData();
}

/***************************************************************************
 * Sets the current profile on the server to what is in the settings.
 ***************************************************************************/
void Kinkatta::setProfile(){
  connection->setUserInfo( setup::instance()->readProfile( setup::settings()->login_name) );
}

/***************************************************************************
 * Check with the website to see if there are any updates.  State no
 * if there is none.
 ***************************************************************************/
void Kinkatta::checkForUpdatesWError(){
  checkForUpdateReportErrors = true;
  checkForUpdates();
}

/***************************************************************************
 * Check with the website to see if there are any updates.
 ***************************************************************************/
void Kinkatta::checkForUpdates(){
  qApp->setOverrideCursor(Qt::waitCursor);
  QString u = "http://kinkatta.sourceforge.net/update/current_version";
  QString settingsFile;
  QString newVersion;
  if (KIO::NetAccess::download( u, settingsFile)) {
    QFile file(settingsFile);
    newVersion = setup::settings()->Version;
    if (file.open(IO_ReadWrite)){
      newVersion = "";
      QTextStream stream(&file);
      while(!stream.eof()){
        newVersion += stream.readLine();
      }
      file.close();
      file.remove();
  } else {
    qApp->restoreOverrideCursor();
    QMessageBox::information(0, "Kinkatta - Error",("Could not retrieve latest version\n"
			"information.  The website might be down."), QMessageBox::Ok);
  }

  // timeouts etc.
  if (newVersion.length() == 0) {
    qApp->restoreOverrideCursor();
    QMessageBox::information(0, "Kinkatta - Error",("Could not retrieve latest version\n"
      "information.  The website might be down."), QMessageBox::Ok);
  }

    bool isNewVersion = false;
    isNewVersion = newVersion != (setup::settings()->Version);
    if (isNewVersion){
      if ((checkForUpdateReportErrors == true) || newVersion != setup::settings()->IgnoreThisUpdate)
			{
        u = "http://kinkatta.sourceforge.net/update/latest_changes";
	if (KIO::NetAccess::download( u, settingsFile)) {
          QFile file(settingsFile);
          QString newChanges = "";
          if (file.open(IO_ReadWrite))
					{
            QTextStream stream(&file);
            while(!stream.eof())
						{
              newChanges += stream.readLine();
	      			newChanges += "\n";
            }
            file.close();
            file.remove();
	  			}
					else
					{
						qApp->restoreOverrideCursor();
            QMessageBox::information(0, "Kinkatta - Error",("Could not retrieve latest version changes\nThe website might be down."), QMessageBox::Ok);
          }
  	  		newChanges = QString("A newer version of Kinkatta has been released.\n\n") + newChanges;
 	  			int choice = -1;
					qApp->restoreOverrideCursor();
	  			choice = QMessageBox::information(0, QString("New Kinkatta Release: ") + newVersion,newChanges, "OK","Open Web Site","Don't show this version again.");
        	if (choice == 1)
	    			browser->openURL(QString( "http://kinkatta.sourceforge.net/ "));
	  			if (choice == 2)
	    			setup::settings()->IgnoreThisUpdate = newVersion;
      	}
    	}
			else
			{
      	qApp->restoreOverrideCursor();
		  	if (checkForUpdateReportErrors == true)
	  			QMessageBox::information(0, "Kinkatta - Results","There are no new versions\n of Kinkatta at this time", "OK");
				checkForUpdateReportErrors = false;
    	}
  	}
    else
		{
     	qApp->restoreOverrideCursor();
	  	if (checkForUpdateReportErrors == true)
	 			QMessageBox::information(0, "Kinkatta - Results","There are no new versions\n of Kinkatta at this time", "OK");
			checkForUpdateReportErrors = false;
   	}
  }
  else {
    qApp->restoreOverrideCursor();
		QMessageBox::information(0, "Kinkatta - Error",("Unable to retrieve version info."), QMessageBox::Ok);
  }
  qApp->restoreOverrideCursor();
}

/***************************************************************************
 * Resizes the Buddy list window
 * Occurs when the window size is changed.
 ***************************************************************************/
void Kinkatta::resizeEvent ( QResizeEvent *e ){
  buddyWindow->setGeometry(0,0,this->width(),this->height());
  QWidget::resizeEvent(e);

  int moveDown = setup::settings()->main_moveDown;
  if ( setup::settings()->main_loginMoveLeft == true){
    this->setGeometry(this->geometry().x() - this->frameGeometry().x(), (this->geometry().y() - this->frameGeometry().y())+moveDown,this->width(),this->height());
  }
  if ( i_aimSettings->main_loginMoveRight == true){
    int rootWidth = (KApplication::desktop())->width();
      this->setGeometry(rootWidth - this->frameGeometry().width(), (this->geometry().y() - this->frameGeometry().y())+moveDown,this->width(),this->height());

  }
}

/***************************************************************************
 * Quits the application
 * Logs off and saves first
 ***************************************************************************/
void Kinkatta::Quit(){
  if (connection->getStatus() != TAIM_OFFLINE){
		i_aimSettings->xSize = this->width();
    i_aimSettings->ySize = this->height();

    quiting = true;
    manualLogOff = true;
   connection->setStatus(TAIM_OFFLINE);
  }

  SaveAimSettings();
  emit quit();
}

/***************************************************************************
 * Close event occured, quit.
 ***************************************************************************/
void Kinkatta::closeEvent(class QCloseEvent *){
  Quit();
}

void Kinkatta::initProgress(int max, int cur, QString msg)
{
	if(progress) delete progress;
	progress = new QProgressDialog(this, "Kinkatta - Login");
	progress->setCaption("Kinkatta - Signon");
	progress->setTotalSteps(max);
	connect( progress, SIGNAL(cancelled()), connection, SLOT(cancelProgress()) );
	progress->setProgress(cur);
	progress->setLabelText(msg);
	progress->show();
}
void Kinkatta::updateProgress(int cur, QString msg)
{
	if(!progress) return;
	progress->setProgress(cur);
	progress->setLabelText(msg);
}
void Kinkatta::endProgress(void)
{
	if(!progress) return;
	delete progress;
	progress = 0;
  loginIn = false;
	if (connection->getStatus() != TAIM_OFFLINE)
		Connected();
}

// kinkatta.cpp
#include "kinkatta.moc"








