/******************************************************************************
                                chatwindow.h
                             -------------------
    begin                : Wednesday March 28 2000
    copyright            : (C) 2001 by Benjamin Meyer
    email                : ben@meyerhome.net
 ******************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 ******************************************************************************/

/******************************************************************************
 * This is the implimentation of a chat "im" window.  It uses the chat class.
 ******************************************************************************/

#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#include "chat.h"
#include "setup.h"

/**
  *@author Benjamin Meyer
  */

class ChatWindow : public Chat {

  Q_OBJECT

  signals:
    void removeBuddy(QString name);
    void blockBuddy(QString name);
    void warningOut(QString userName);
		void saveNewSize(int x, int y, int s1);
		void pounce(QString);

  public:
    ChatWindow(QString userName, QString buddysName, bool buddy, QWidget *parent=0, QString alias=0);
    ~ChatWindow();
   void setSize(int x, int y, int s1);

  public slots:
    void setIfIsBuddy(QString name, bool isABuddy);
    void updateChatToolBarSettings();
    void updateBuddyName(QString buddy);

  private slots:
    void slotBuddyBlock();
    void slotBuddyWarn();
    void slotBuddyAddRemove();
    void slotBuddyInfo();
    void initToolBar();
    void initMenuBar();
    void initChatWindow();
		void saveSize();
		void slotBuddyPounce();

  private:
    QToolButton *userRemoveButton;
    QToolButton *userWarnButton;
    QToolButton *userBlockButton;
    QToolButton *userInfoButton;
		QToolButton *buddyPounceButton;

    im_ToolBar_Settings *imToolBarSettings;
    bool isBuddy;

};

#endif

// chatwindow.h


