/******************************************************************************
                                chatwindow.cpp
                             -------------------
    begin                : Wednesdat May 28 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ******************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 ******************************************************************************/

/******************************************************************************
 * This is the implimentation of a chat "im" window.  It uses the chat class.
 ******************************************************************************/

#include "chatwindow.h"
#include <kiconloader.h>
#include <ktoolbar.h>
//#include <qtoolbutton.h>
#include <qsplitter.h>
#include <kpopupmenu.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
ChatWindow::ChatWindow(QString userName, QString buddysName, bool buddy, QWidget *parent, QString alias): Chat(userName,buddysName,parent, alias){
  imToolBarSettings = new im_ToolBar_Settings();
  imToolBarSettings->chat_remove = true;
  imToolBarSettings->chat_warn = false;
  imToolBarSettings->chat_block = true;
  imToolBarSettings->chat_info = true;
  imToolBarSettings->chat_pounce = false;
  isBuddy = buddy;
  imToolBarSettings = setup::settings()->imToolBarSettings;
  this->initToolBar();
  this->initChatWindow();
  this->initMenuBar();
  this->setMinimumSize(250,250);
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
ChatWindow::~ChatWindow(){

}

void ChatWindow::updateChatToolBarSettings(){
	//qDebug("ChatWindow::updateChatToolBarSettings\n");

	imToolBarSettings = setup::settings()->imToolBarSettings;
	this->initToolBar(); 
	
	Chat::updateChatToolBarSettings(); //this will also call Chat::initToolBar();

}
/******************************************************************************
 * Set the current size of the window.
 ******************************************************************************/
void ChatWindow::setSize(int x, int y, int s1){
  this->resize(x,y);
  
  QValueList<int> list;
  list = spliter->sizes();
  list[1] = s1;
  spliter->setSizes(list);
}

/******************************************************************************
 * Save the size of the window.
 ******************************************************************************/
void ChatWindow::saveSize(){
  QValueList<int> list;
  list = spliter->sizes();
  int s1 = list[1];

  emit saveNewSize(this->width(),this->height(),s1);
}


/******************************************************************************
 * Save the size of the window.
 ******************************************************************************/
void ChatWindow::slotBuddyPounce(){
  emit (pounce(buddyName));
}

/******************************************************************************
 * ToolBar setup  Clears the toolbars and fills them with the widgets
 * specified in toolBarSettings then oriants the toolbars as chosen.
 ******************************************************************************/
void ChatWindow::initToolBar(){
  Chat::initToolBar();
  if ( imToolBarSettings->chat_info == true)
    fileToolbar->insertButton("viewmag",-1,SIGNAL(clicked()), this, SLOT(slotBuddyInfo()),true,"Buddy Info", -1);
  
  if (imToolBarSettings->chat_warn == true)
    fileToolbar->insertButton("kinkatta_warn",-1,SIGNAL(clicked()), this, SLOT(slotBuddyWarn()),true,"Warn Buddy", -1);

	if (imToolBarSettings->chat_block == true)
    fileToolbar->insertButton("kinkatta_block",-1,SIGNAL(clicked()), this, SLOT(slotBuddyBlock()),true,"Block Buddy", -1);
	if (imToolBarSettings->chat_pounce == true)
    fileToolbar->insertButton("bottom",-1,SIGNAL(clicked()), this, SLOT(slotBuddyPounce()),true,"Pounce Buddy", -1);

  if (imToolBarSettings->chat_remove == true){
    if(isBuddy == true)
      fileToolbar->insertButton("kinkatta_buddy_remove", -1, SIGNAL(clicked()), this, SLOT(slotBuddyAddRemove()), true, "Remove Buddy", -1);
    else
      fileToolbar->insertButton("kinkatta_buddy_add", -1, SIGNAL(clicked()), this, SLOT(slotBuddyAddRemove()), true, "Add Buddy", -1);
  }

}

/******************************************************************************
 *
 ******************************************************************************/
void ChatWindow::initMenuBar(){
  Chat::initMenuBar();
  buddyMenu->insertItem(SmallIcon("viewmag"), "&Buddy Info", this, SLOT(slotBuddyInfo()), 0, ID_BUDDY_INFO);

  buddyMenu->insertItem(SmallIcon("kinkatta_warn"), "&Warn Buddy...", this, SLOT(slotBuddyWarn()), 0, ID_BUDDY_WARN);
  if (isBuddy == true)
    buddyMenu->insertItem(SmallIcon("kinkatta_buddy_remove"), "&Remove Buddy...", this, SLOT(slotBuddyAddRemove()), 0, ID_BUDDY_REMOVE);
  else
    buddyMenu->insertItem(SmallIcon("kinkatta_buddy_add"), "&Add Buddy", this, SLOT(slotBuddyAddRemove()), 0, ID_BUDDY_REMOVE);
  
  buddyMenu->insertItem(SmallIcon("kinkatta_block"), "B&lock Buddy...", this, SLOT(slotBuddyBlock()), 0, ID_BUDDY_BLOCK);
	
	viewMenu->insertSeparator();
	viewMenu->insertItem("&Save Size", this, SLOT(saveSize()), 0, ID_VIEW_SAVESIZE);

  buddyMenu->insertItem(SmallIcon("bottom"), "&Pounce...", this, SLOT(slotBuddyPounce()), 0, 0);
}


void ChatWindow::initChatWindow(){
  spliter = new QSplitter(this, "Splitter" );
  Chat::initChatWindow();
}

/******************************************************************************
 * Get information about the current buddy
 ******************************************************************************/
void ChatWindow::slotBuddyInfo(){
  emit( getInfo( buddyName ) );
}

/******************************************************************************
 * Sets if the buddy is on the buddy list of not.
 ******************************************************************************/
void ChatWindow::setIfIsBuddy(QString name, bool isABuddy){
  if (name != buddyName)
    return;
  isBuddy = isABuddy;
  this->initToolBar();
  this->initMenuBar();
}

/******************************************************************************
 * Send a warning message against the buddy
 * Pass to main window for conferm/action
 ******************************************************************************/
void ChatWindow::slotBuddyWarn(){
  emit( warningOut(buddyName) );
}

/******************************************************************************
 * Block this buddy from being on my list.
 * Pass to main window for conferm/action
 ******************************************************************************/
void ChatWindow::slotBuddyBlock(){
  emit( blockBuddy(buddyName) );
}

/******************************************************************************
 * Remove the buddy from the current list
 * Pass to main window for conferm/action
 ******************************************************************************/
void ChatWindow::slotBuddyAddRemove(){
  if (isBuddy == true){
    emit( removeBuddy(buddyName) );
  }
  else{
    emit( addBuddy(buddyName) );
  }
}

/******************************************************************************
 * update buddyName
 ******************************************************************************/
void ChatWindow::updateBuddyName(QString buddy){
  buddyName = buddy;
}

// chatwindow.cpp





