/***************************************************************************
                             chatroominviteimp.h
                             -------------------
    begin                : Saturday March 24 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : ben@meyerhome.net
 ***************************************************************************/

#include "chatroominviteimp.h"
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qstring.h>
#include <qlistbox.h>
#include <qmessagebox.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
ChatRoomInviteImp::ChatRoomInviteImp(QWidget *parent, const char *name) : ChatRoomInvite( parent,name,false ){
  connect(buttonInvite, SIGNAL(clicked()), this, SLOT(inviteBuddyButton()));
  connect(add, SIGNAL(clicked()), this, SLOT(addBuddyButton()));
  connect(buddyList, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(doubleClicked( QListBoxItem * )));

  room = 0;
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
ChatRoomInviteImp::~ChatRoomInviteImp(){
}

/******************************************************************************
 * Add double click so it too works.
 ******************************************************************************/
void ChatRoomInviteImp::doubleClicked( QListBoxItem * ){
  addBuddyButton();
}

/******************************************************************************
 * Invite button pressed, check for empty cases.
 ******************************************************************************/
void ChatRoomInviteImp::inviteBuddyButton(){
  if ((buddy->text()).length() == 0){
    QMessageBox::information(this, "Kinkatta - Message",("Please enter a buddy to invite."), QMessageBox::Ok);
    return;
  }
  emit inviteBuddy(room, message->text(), buddy->text());
  this->accept();
}

/******************************************************************************
 * When the add button is clicked it adds the current buddy to the buddies.
 ******************************************************************************/
void ChatRoomInviteImp::addBuddyButton(){
  if ((buddy->text()).length() == 0)
    buddy->setText(buddyList->currentText());
  else
    buddy->setText(buddy->text() += ", " + buddyList->currentText());
}

// chatroominviteimp.cpp
