/******************************************************************************
                                chatroom.h
                             -------------------
    begin                : Wednesday March 28 2000
    copyright            : (C) 2001 by Benjamin Meyer
    email                : ben@meyerhome.net
 ******************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 ******************************************************************************/

/******************************************************************************
 * This is the implimentation of a chat "room" window.  It uses the chat class.
 ******************************************************************************/

#ifndef CHATROOM_H
#define CHATROOM_H

#include "chat.h"
#include "taim.h"
#include "setup.h"

class ChatRoomControlImp;

/**
  *@author Benjamin Meyer
  */

class ChatRoom : public Chat {

Q_OBJECT

signals:
  void im(QString buddyName);
  void showInviteWidget(int);
	void saveNewSize(int x, int y, int s1, int s2);

public:
  ChatRoom(QString userName, QString buddysName, QWidget *parent=0);
  ~ChatRoom();
  void setSize(int x, int y, int s1, int s2);

public slots:
  void messageInParse(QString buddy, bool whisper, QString message);
  void leftRoom();
  void updateBuddy(QString buddy, bool curstat);
  void updateChatToolBarSettings();

private slots:
  void initToolBar();
  void initMenuBar();
  void initChatWindow();
	void saveSize();
  void slotBuddyInvite();

private:
  ChatRoomControlImp* control;
  QToolButton *userInviteButton;
  QToolButton *buddyWhisperButton;

  room_ToolBar_Settings *roomToolBarSettings;
  QSplitter *vSpliter;

};

#endif

// chatroom.h


