/***************************************************************************
					                          chat.h
					                   -------------------
		begin                : Wednesday March 28 2000
		copyright            : (C) 2001 by Benjamin Meyer
		email                : ben@meyerhome.net
 ***************************************************************************/

/***************************************************************************
 * This is the base class for a chat. 
 ***************************************************************************/

#ifndef CHAT_H
#define CHAT_H

#include <qmainwindow.h>
#include "ktextbrowser.h"
#include "setup.h"
#include "resource.h"

class QMultiLineEdit;
class QSplitter;
class QToolButton;
class KToolBar;
class KMenuBar;
class QLabel;
class QTextStream;
class QFile;
class QColor;
class KPopupMenu;
class Browser;
class Sound;
	
/**
  *@author Benjamin Meyer
  */

class Chat : public QMainWindow  {

	Q_OBJECT

	signals:
		void messageOut(QString buddy, QString Message, int room);
		void addBuddy(QString name);
		void getInfo(QString Name);
		void quiting(QString name, int room);
		void showAbout();
		void openHomePage();
		
	public:
		Chat(QString userName, QString buddysName, QWidget *parent=0, QString alias=0);
		~Chat();
		void buddySignedOff();
		void buddySignedOn();
		void pounceMessage(QString message);
		void awayMessage(QString message);
		bool sentAwayMessageToBuddy;
		Browser *browser;
		Sound *sound;
		int room;
		QString name;

	protected:
		// Internal Settings
		QString myName;
		QString buddyName;
	 
		// The widgets in the tool bar
		QToolButton *sendMessageButton;
 
		QToolButton *chatClearButton;
		QToolButton *chatSaveButton;
		QToolButton *chatPrintButton;
		int chatTimeButton;
		int chatLogButton;
		int chatSoundMuteButton;
 
		QToolButton *textBoldButton;
		QToolButton *textItalicButton;
		QToolButton *textUnderLineButton;
		QToolButton *textStrikeButton;
 
		QToolButton *textUpFontButton;
		QToolButton *textNormFontButton;
		QToolButton *textDownFontButton;
		QToolButton *colorBackButton;
		QToolButton *colorPenButton;
		QToolButton *linkButton;
		QToolButton *smileyButton;
	
		// The Menu Bars
		KMenuBar *kmenuBar;
		KPopupMenu *fileMenu;
		KPopupMenu *editMenu;
		KPopupMenu *viewMenu;
		KPopupMenu *insertMenu;
		KPopupMenu *insertFaceMenu;
		KPopupMenu *buddyMenu;
		KPopupMenu *helpMenu;

	 	KToolBar *fileToolbar;
		KToolBar *textToolbar;

		// The init function for the widget
		virtual void initToolBar();
		virtual void initMenuBar();
		virtual void initChatWindow();
	
		QSplitter *spliter;

		//The following are for delayed local settings creation.
		chat_ToolBar_Settings *toolBarSettings;
		chat_Color_Settings *colorSettings;
		chat_Font_Settings *fontSettings;
		chat_Settings *chatSettings;
		chat_Sound_Settings *soundSettings;

		bool chatSettings_chat_log;
		bool toolBarSettings_chat_log;
		bool soundSettings_chat_sound;
		bool soundSettings_chat_sound_beepReceive;
		bool soundSettings_chat_sound_beepSend;
		bool chatSettings_chat_show_time;
		bool chatSettings_chat_log_time;
		QColor colorSettings_chat_yourbg_color;
		QColor colorSettings_chat_yourText_color;
		QColor colorSettings_chat_buddybg_color;
		QColor colorSettings_chat_buddyText_color;

	private:
		QString currentMessageOut;
		bool shiftIsPressed;
		bool cleared;
		bool canCopy;
		int fontSize;
		int normalFontSize;
		
		QColor temp_BuddyBgColor;
		QColor temp_BuddyTextColor;
		QString lastMessage;
		bool default_yourFont;
		bool default_buddyFont;

		// The Log Data's
		QFile logFile;
		QTextStream logStream;

		// The two buffers, one with time, one without.
		QString conversationBuffer;
		QString conversationTimeBuffer;
		
		// Normal function calls in the app
		void updateHTML(QString message, QString sender, QString HTMLColor);
		QString parseAndProcessALL(QString &newstr);
		void parseAndProcess(QString &newstr);
		QString parseForSpecialCharacters(QString &newstr);
		QString parseForHTML(QString &newstr);
		QString parseForSpelling(QString &newstr);
		QString parseForAutoReplace(QString &newstr);
	
		QString stripTags(const QString &oldstr);
		void openLogFile(void);
		int ptsizetohtml(int pointsize);
		QString fontTagHTML(QString face, QString color, int size);
		QString fontFixSmilies(QString message, QString fontTag);
		QString updateHTMLSmilyPic(QString message);
 
		// The Chat window
		KinkattaTextBrowser *chatWindow;
		
		// used to get around the 0/1 issue on chatWindow input
		int postNumber;
		// Flash vars
		bool flashWindow;
		bool flashNumber;
		QMultiLineEdit *inputWindow;
 	
	public slots:
		void messageIn(QString message);
		
		void updateChatToolBarSettings();
		void updateChatColorSettings();
		void updateChatFontSettings();
		void updateChatSettings();
		void updateChatSoundSettings();
	
	private slots:
		void flashIcon();
		void enterKeyPressed();
                void applytoInputWindow();
		void applytoChatWindow();
		void inputTextChanged();
		void copyChanged(bool);
		void urlClicked(const QString &url);

	  void mailToClicked(const QString &url, const QString &address);
	
		void slotChatLog();
		void slotChatClear();
		void slotChatSaveAs();
		void slotChatPrint();
		void slotChatClose();
		void slotChatSound();

		void slotEditTurnOnOffUndo(bool);
		void slotEditTurnOnOffRedo(bool);
		void slotEditUndo();
		void slotEditRedo();
		void slotEditCut();
		void slotEditCopy();
		void slotEditPaste();
		void slotEditSelectAll();

		void slotViewChatToolBar();
		void slotViewTextToolBar();
		void slotViewTimeStamp();

		void slotInsertFace(int);
		void slotInsertTags(QString open, QString close);
		void slotInsertBold();
		void slotInsertItalic();
		void slotInsertUnderline();
		void slotInsertShrinkFont();
		void slotInsertNormalFont();
		void slotInsertIncreaseFont();
		void slotInsertBackGroundColor();
		void slotInsertPenColor();
		void slotInsertLink();
		void slotInsertLastMessage();
	
		void slotBuddySendMessage();

	protected:
		void keyReleaseEvent(QKeyEvent *e);
		void keyPressEvent(QKeyEvent *e);
		void resizeEvent(QResizeEvent *e );
		void closeEvent(QCloseEvent *);

};

#endif

// chat.h







